/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.amf;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.ArrayShape;
import amf.client.model.domain.Example;
import amf.client.model.domain.FileShape;
import amf.client.model.domain.Shape;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonExampleTypeLoader;
import org.mule.metadata.json.api.JsonTypeLoader;

class MetadataFactory {
    private static final MetadataType DEFAULT_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).anyType().build();
    private static final MetadataType STRING_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();
    private static final MetadataType ARRAY_STRING_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType().of(STRING_METADATA).build();
    private static final MetadataType DATE_TIME_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).dateTimeType().build();
    private static final MetadataType BOOLEAN_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).booleanType().build();
    private static final MetadataType INTEGER_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).numberType().integer().build();
    private static final MetadataType NUMBER_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).numberType().build();

    private MetadataFactory() {
    }

    public static MetadataType from(Shape shape) {
        Optional metadataType = Optional.empty();
        if (shape instanceof AnyShape) {
            AnyShape anyShape = (AnyShape)shape;
            List examples = anyShape.examples();
            JsonTypeLoader typeLoader = anyShape.isDefaultEmpty() && !examples.isEmpty() ? MetadataFactory.createJsonExampleTypeLoader(((Example)examples.get(0)).value().value()) : new JsonTypeLoader(anyShape.toJsonSchema());
            metadataType = typeLoader.load(null);
        }
        return metadataType.orElse(MetadataFactory.defaultMetadata());
    }

    static MetadataType defaultMetadata(Shape shape) {
        if (shape instanceof FileShape) {
            return MetadataFactory.stringMetadata();
        }
        if (shape instanceof ArrayShape) {
            return MetadataFactory.arrayStringMetadata();
        }
        return MetadataFactory.defaultMetadata();
    }

    private static JsonExampleTypeLoader createJsonExampleTypeLoader(String example) {
        JsonExampleTypeLoader typeLoader = new JsonExampleTypeLoader(example);
        typeLoader.setFieldRequirementDefault(false);
        return typeLoader;
    }

    static MetadataType defaultMetadata() {
        return DEFAULT_METADATA;
    }

    static MetadataType stringMetadata() {
        return STRING_METADATA;
    }

    static MetadataType arrayStringMetadata() {
        return ARRAY_STRING_METADATA;
    }

    static MetadataType booleanMetadada() {
        return BOOLEAN_METADATA;
    }

    static MetadataType numberMetadata() {
        return NUMBER_METADATA;
    }

    static MetadataType integerMetadata() {
        return INTEGER_METADATA;
    }

    static MetadataType dateTimeMetadata() {
        return DATE_TIME_METADATA;
    }

    static MetadataType objectMetadata() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().build();
    }

    static MetadataType binaryMetadata() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).binaryType().build();
    }
}

