/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinateFactory;
import org.mule.module.apikit.metadata.internal.model.ApikitConfig;
import org.mule.module.apikit.metadata.internal.model.ApikitElementIdentifiers;
import org.mule.module.apikit.metadata.internal.model.Flow;
import org.mule.module.apikit.metadata.internal.model.FlowMapping;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;

public class ApplicationModelWrapper {
    private static final String PARAMETER_NAME = "name";
    private static final String PARAMETER_API_DEFINITION = "api";
    private static final String PARAMETER_RAML_DEFINITION = "raml";
    private static final String PARAMETER_OUTPUT_HEADERS_VAR = "outboundHeadersMapName";
    private static final String PARAMETER_HTTP_STATUS_VAR = "httpStatusVarName";
    private static final String PARAMETER_PARSER = "parser";
    private static final String PARAMETER_RESOURCE = "resource";
    private static final String PARAMETER_ACTION = "action";
    private static final String PARAMETER_CONTENT_TYPE = "content-type";
    private static final String PARAMETER_FLOW_REF = "flow-ref";
    private static final ComponentIdentifier FLOW = ComponentIdentifier.buildFromStringRepresentation((String)"flow");
    private static final ComponentIdentifier APIKIT_CONFIG = ComponentIdentifier.buildFromStringRepresentation((String)"apikit:config");
    private final ApplicationModel applicationModel;
    private final ResourceLoader resourceLoader;
    private final Notifier notifier;
    private Map<String, ApikitConfig> configMap;
    private Map<String, ApiCoordinate> metadataFlows;

    public ApplicationModelWrapper(ApplicationModel applicationModel, ResourceLoader loader, Notifier notifier) {
        this.applicationModel = applicationModel;
        this.resourceLoader = loader;
        this.notifier = notifier;
        this.configMap = this.loadConfigs();
        this.metadataFlows = this.loadFlows();
    }

    private Map<String, ApiCoordinate> loadFlows() {
        List<Flow> flows = this.findFlows();
        ApiCoordinateFactory coordsFactory = new ApiCoordinateFactory(this.getConfigNames());
        Map<String, ApiCoordinate> conventionCoordinates = this.createCoordinatesForConventionFlows(flows, coordsFactory);
        Map<String, ApiCoordinate> flowMappingCoordinates = this.createCoordinatesForMappingFlows(flows, coordsFactory);
        HashMap<String, ApiCoordinate> result = new HashMap<String, ApiCoordinate>(conventionCoordinates);
        result.putAll(flowMappingCoordinates);
        return result;
    }

    private Map<String, ApikitConfig> loadConfigs() {
        return this.applicationModel.getRootComponentModel().getInnerComponents().stream().filter(ApplicationModelWrapper::isApikitConfig).map(this::createApikitConfig).collect(Collectors.toMap(ApikitConfig::getName, Function.identity()));
    }

    private Set<String> getConfigNames() {
        return this.configMap.keySet();
    }

    Collection<ApikitConfig> getConfigurations() {
        return this.configMap.values();
    }

    private Map<String, ApiCoordinate> createCoordinatesForConventionFlows(List<Flow> flows, ApiCoordinateFactory coordsFactory) {
        return flows.stream().map(flow -> coordsFactory.fromFlowName(flow.getName())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ApiCoordinate::getFlowName, Function.identity()));
    }

    private ApikitConfig createApikitConfig(ComponentModel config) {
        Map parameters = config.getParameters();
        String configName = (String)parameters.get(PARAMETER_NAME);
        String apiDefinition = ApplicationModelWrapper.getApiDefinition(parameters);
        String outputHeadersVarName = (String)parameters.get(PARAMETER_OUTPUT_HEADERS_VAR);
        String httpStatusVarName = (String)parameters.get(PARAMETER_HTTP_STATUS_VAR);
        String parser = (String)parameters.get(PARAMETER_PARSER);
        List<FlowMapping> flowMappings = config.getInnerComponents().stream().filter(cfg -> ApikitElementIdentifiers.isFlowMappings(cfg.getIdentifier())).flatMap(flowMappingsElement -> flowMappingsElement.getInnerComponents().stream()).filter(flowMapping -> ApikitElementIdentifiers.isFlowMapping(flowMapping.getIdentifier())).map(unwrappedFlowMapping -> ApplicationModelWrapper.createFlowMapping(configName, unwrappedFlowMapping)).collect(Collectors.toList());
        return new ApikitConfig(configName, apiDefinition, flowMappings, httpStatusVarName, outputHeadersVarName, parser, this.resourceLoader, this.notifier);
    }

    private static String getApiDefinition(Map<String, String> parameters) {
        if (parameters.containsKey(PARAMETER_API_DEFINITION)) {
            return parameters.get(PARAMETER_API_DEFINITION);
        }
        if (parameters.containsKey(PARAMETER_RAML_DEFINITION)) {
            return parameters.get(PARAMETER_RAML_DEFINITION);
        }
        return null;
    }

    public List<Flow> findFlows() {
        return ApplicationModelWrapper.findFlows(this.applicationModel);
    }

    public static List<Flow> findFlows(ApplicationModel applicationModel) {
        return applicationModel.getRootComponentModel().getInnerComponents().stream().filter(ApplicationModelWrapper::isFlow).map(ApplicationModelWrapper::createFlow).collect(Collectors.toList());
    }

    private static Flow createFlow(ComponentModel componentModel) {
        Map parameters = componentModel.getParameters();
        String flowName = (String)parameters.get(PARAMETER_NAME);
        return new Flow(flowName);
    }

    public Optional<ApiCoordinate> getApiCoordinate(String flowName) {
        return Optional.ofNullable(this.metadataFlows.get(flowName));
    }

    public Optional<ApikitConfig> getConfig(String name) {
        if (this.configMap.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.configMap.getOrDefault(name, this.configMap.values().iterator().next()));
    }

    private Map<String, ApiCoordinate> createCoordinatesForMappingFlows(List<Flow> flows, ApiCoordinateFactory factory) {
        Set flowNames = flows.stream().map(Flow::getName).collect(Collectors.toSet());
        return this.configMap.values().stream().flatMap(config -> config.getFlowMappings().stream()).filter(mapping -> flowNames.contains(mapping.getFlowRef())).map(factory::createFromFlowMapping).collect(Collectors.toMap(ApiCoordinate::getFlowName, Function.identity()));
    }

    private static boolean isFlow(ComponentModel component) {
        return component.getIdentifier().equals(FLOW);
    }

    private static boolean isApikitConfig(ComponentModel component) {
        return component.getIdentifier().equals(APIKIT_CONFIG);
    }

    private static FlowMapping createFlowMapping(String configName, ComponentModel component) {
        Map flowMappingParameters = component.getParameters();
        String resource = (String)flowMappingParameters.get(PARAMETER_RESOURCE);
        String action = (String)flowMappingParameters.get(PARAMETER_ACTION);
        String contentType = (String)flowMappingParameters.get(PARAMETER_CONTENT_TYPE);
        String flowRef = (String)flowMappingParameters.get(PARAMETER_FLOW_REF);
        return new FlowMapping(configName, resource, action, contentType, flowRef);
    }
}

