/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinateFactory;

public class ApiCoordinateFactoryTest {
    @Test
    public void twoConfigsTest() {
        ApiCoordinateFactory factory = new ApiCoordinateFactory(this.set("config1", "config2"));
        Optional coord = factory.fromFlowName("get:\\persons:config1");
        Assert.assertTrue((boolean)coord.isPresent());
        Assert.assertEquals((Object)"get:\\persons:config1", (Object)((ApiCoordinate)coord.get()).getFlowName());
        Assert.assertEquals((Object)"get", (Object)((ApiCoordinate)coord.get()).getMethod());
        Assert.assertEquals((Object)"/persons", (Object)((ApiCoordinate)coord.get()).getResource());
        Assert.assertNull((Object)((ApiCoordinate)coord.get()).getMediaType());
        Assert.assertEquals((Object)"config1", (Object)((ApiCoordinate)coord.get()).getConfigName());
        coord = factory.fromFlowName("post:\\offices:config2");
        Assert.assertTrue((boolean)coord.isPresent());
        Assert.assertEquals((Object)"post:\\offices:config2", (Object)((ApiCoordinate)coord.get()).getFlowName());
        Assert.assertEquals((Object)"post", (Object)((ApiCoordinate)coord.get()).getMethod());
        Assert.assertEquals((Object)"/offices", (Object)((ApiCoordinate)coord.get()).getResource());
        Assert.assertNull((Object)((ApiCoordinate)coord.get()).getMediaType());
        Assert.assertEquals((Object)"config2", (Object)((ApiCoordinate)coord.get()).getConfigName());
        coord = factory.fromFlowName("post:\\offices:application\\json:config2");
        Assert.assertTrue((boolean)coord.isPresent());
        Assert.assertEquals((Object)"post:\\offices:application\\json:config2", (Object)((ApiCoordinate)coord.get()).getFlowName());
        Assert.assertEquals((Object)"post", (Object)((ApiCoordinate)coord.get()).getMethod());
        Assert.assertEquals((Object)"/offices", (Object)((ApiCoordinate)coord.get()).getResource());
        Assert.assertEquals((Object)"application/json", (Object)((ApiCoordinate)coord.get()).getMediaType());
        Assert.assertEquals((Object)"config2", (Object)((ApiCoordinate)coord.get()).getConfigName());
        coord = factory.fromFlowName("post:\\offices");
        Assert.assertTrue((!coord.isPresent() ? 1 : 0) != 0);
        coord = factory.fromFlowName("post:\\incomplete:application\\json:config2:illegal");
        Assert.assertTrue((!coord.isPresent() ? 1 : 0) != 0);
        coord = factory.fromFlowName("post:\\offices:application\\json:unknown-config");
        Assert.assertTrue((!coord.isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void oneConfigTest() {
        ApiCoordinateFactory factory = new ApiCoordinateFactory(this.set("config"));
        Optional coord = factory.fromFlowName("get:\\persons");
        Assert.assertTrue((boolean)coord.isPresent());
        Assert.assertEquals((Object)"get:\\persons", (Object)((ApiCoordinate)coord.get()).getFlowName());
        Assert.assertEquals((Object)"get", (Object)((ApiCoordinate)coord.get()).getMethod());
        Assert.assertEquals((Object)"/persons", (Object)((ApiCoordinate)coord.get()).getResource());
        Assert.assertNull((Object)((ApiCoordinate)coord.get()).getMediaType());
        Assert.assertNull((Object)((ApiCoordinate)coord.get()).getConfigName());
        coord = factory.fromFlowName("get:\\persons");
        Assert.assertTrue((boolean)coord.isPresent());
        Assert.assertEquals((Object)"get:\\persons", (Object)((ApiCoordinate)coord.get()).getFlowName());
        Assert.assertEquals((Object)"get", (Object)((ApiCoordinate)coord.get()).getMethod());
        Assert.assertEquals((Object)"/persons", (Object)((ApiCoordinate)coord.get()).getResource());
        Assert.assertNull((Object)((ApiCoordinate)coord.get()).getMediaType());
        Assert.assertNull((Object)((ApiCoordinate)coord.get()).getConfigName());
        coord = factory.fromFlowName("get:\\persons:application\\json:config");
        Assert.assertTrue((boolean)coord.isPresent());
        Assert.assertEquals((Object)"get:\\persons:application\\json:config", (Object)((ApiCoordinate)coord.get()).getFlowName());
        Assert.assertEquals((Object)"get", (Object)((ApiCoordinate)coord.get()).getMethod());
        Assert.assertEquals((Object)"/persons", (Object)((ApiCoordinate)coord.get()).getResource());
        Assert.assertEquals((Object)"application/json", (Object)((ApiCoordinate)coord.get()).getMediaType());
        Assert.assertEquals((Object)"config", (Object)((ApiCoordinate)coord.get()).getConfigName());
        coord = factory.fromFlowName("get:\\persons:application\\json:unknownConfig");
        Assert.assertTrue((!coord.isPresent() ? 1 : 0) != 0);
    }

    private HashSet<String> set(String ... configs) {
        return new HashSet<String>(Arrays.asList(configs));
    }
}

