/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.raml;

import java.net.URI;
import java.util.Optional;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.api.ApiReference;
import org.mule.module.apikit.metadata.internal.model.MetadataResolver;
import org.mule.module.apikit.metadata.internal.model.MetadataResolverFactory;
import org.mule.module.apikit.metadata.internal.raml.RamlApiWrapper;
import org.mule.parser.service.ParserMode;
import org.mule.parser.service.ParserService;
import org.mule.parser.service.result.ParseResult;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;
import org.mule.runtime.core.api.util.StringUtils;

public class RamlHandler
implements MetadataResolverFactory {
    private final ResourceLoader resourceLoader;
    private final Notifier notifier;
    private final ParserService SERVICE = new ParserService();

    public RamlHandler(ResourceLoader resourceLoader, Notifier notifier) {
        this.resourceLoader = resourceLoader;
        this.notifier = notifier;
    }

    @Override
    public Optional<MetadataResolver> getMetadataResolver(String apiDefinition) {
        return this.getApi(apiDefinition).map(raml -> new RamlApiWrapper((ApiSpecification)raml, this.notifier));
    }

    public Optional<ApiSpecification> getApi(String uri) {
        try {
            if (StringUtils.isEmpty((String)uri)) {
                this.notifier.error("RAML document is undefined.");
                return Optional.empty();
            }
            ParseResult result = this.SERVICE.parse(ApiReference.create((String)uri, (org.mule.apikit.loader.ResourceLoader)new ResourceLoaderAdapter(this.resourceLoader)), ParserMode.RAML);
            if (!result.success()) {
                result.getErrors().forEach(error -> this.notifier.error(error.cause()));
                return Optional.empty();
            }
            return Optional.of(result.get());
        }
        catch (Exception e) {
            this.notifier.error(String.format("Error reading RAML document '%s'. Detail: %s", uri, e.getMessage()));
            return Optional.empty();
        }
    }

    private class ResourceLoaderAdapter
    implements org.mule.apikit.loader.ResourceLoader {
        private final ResourceLoader resourceLoader;

        ResourceLoaderAdapter(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        public URI getResource(String res) {
            return this.resourceLoader.getResource(res);
        }
    }
}

