/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.amf;

import amf.client.model.domain.WebApi;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import org.mule.amf.impl.AMFParser;
import org.mule.apikit.model.api.ApiReference;
import org.mule.module.apikit.metadata.internal.amf.AmfWrapper;
import org.mule.module.apikit.metadata.internal.model.MetadataResolver;
import org.mule.module.apikit.metadata.internal.model.MetadataResolverFactory;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;
import org.mule.runtime.core.api.util.StringUtils;

public class AmfHandler
implements MetadataResolverFactory {
    private final ResourceLoader resourceLoader;
    private final Notifier notifier;

    public AmfHandler(ResourceLoader resourceLoader, Notifier notifier) {
        this.resourceLoader = resourceLoader;
        this.notifier = notifier;
    }

    @Override
    public Optional<MetadataResolver> getMetadataResolver(String apiDefinition) {
        return this.getApi(apiDefinition).map(webApi -> new AmfWrapper((WebApi)webApi, this.notifier));
    }

    Optional<WebApi> getApi(String apiDefinition) {
        if (StringUtils.isEmpty((String)apiDefinition)) {
            this.notifier.error("API definition is undefined using AMF parser.");
            return Optional.empty();
        }
        try {
            ApiReference apiRef = ApiReference.create((String)apiDefinition, (org.mule.apikit.loader.ResourceLoader)AmfHandler.adaptResourceLoader(this.resourceLoader));
            AMFParser parserWrapper = new AMFParser(apiRef, true);
            this.notifier.info(String.format("Metadata for API definition '%s' was generated using AMF parser.", apiDefinition));
            return Optional.of(parserWrapper.getWebApi());
        }
        catch (Exception e) {
            this.notifier.error(String.format("Error reading API definition '%s' using AMF parser. Detail: %s", apiDefinition, e.getMessage()));
            return Optional.empty();
        }
    }

    private static org.mule.apikit.loader.ResourceLoader adaptResourceLoader(final ResourceLoader resourceLoader) {
        return new org.mule.apikit.loader.ResourceLoader(){

            public URI getResource(String path) {
                return resourceLoader.getResource(path);
            }

            public InputStream getResourceAsStream(String relativePath) {
                return resourceLoader.getResourceAsStream(relativePath);
            }
        };
    }
}

