/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.amf;

import amf.client.model.domain.EndPoint;
import amf.client.model.domain.Operation;
import amf.client.model.domain.Parameter;
import amf.client.model.domain.Payload;
import amf.client.model.domain.Request;
import amf.client.model.domain.Response;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.module.apikit.metadata.internal.amf.MetadataFactory;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.module.apikit.metadata.internal.model.CertificateFields;
import org.mule.module.apikit.metadata.internal.model.HttpRequestAttributesFields;
import org.mule.runtime.apikit.metadata.api.MetadataSource;
import org.mule.runtime.apikit.metadata.api.Notifier;

class FlowMetadata
implements MetadataSource {
    private static final String PARAMETER_INPUT_METADATA = "inputMetadata";
    private static final String STATUS_CODE_200 = "200";
    private final EndPoint endPoint;
    private final Operation operation;
    private final ApiCoordinate coordinate;
    private final Map<String, Parameter> baseUriParameters;
    private final Notifier notifier;

    FlowMetadata(EndPoint endPoint, Operation operation, ApiCoordinate coordinate, Map<String, Parameter> baseUriParameters, Notifier notifier) {
        this.endPoint = endPoint;
        this.operation = operation;
        this.coordinate = coordinate;
        this.baseUriParameters = baseUriParameters;
        this.notifier = notifier;
    }

    public Optional<FunctionType> getMetadata() {
        MuleEventMetadataType input = this.inputMetadata(this.operation, this.coordinate, this.baseUriParameters);
        MuleEventMetadataType output = this.outputMetadata(this.operation, this.coordinate);
        FunctionTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).functionType();
        FunctionType function = builder.addParameterOf(PARAMETER_INPUT_METADATA, (MetadataType)input).returnType((MetadataType)output).build();
        return Optional.of(function);
    }

    private MuleEventMetadataType inputMetadata(Operation operation, ApiCoordinate coordinate, Map<String, Parameter> baseUriParameters) {
        MessageMetadataType message = new MessageMetadataTypeBuilder().payload(this.getInputPayload(operation, coordinate)).attributes((MetadataType)this.getInputAttributes(operation, baseUriParameters)).build();
        return new MuleEventMetadataTypeBuilder().message(message).build();
    }

    private MuleEventMetadataType outputMetadata(Operation operation, ApiCoordinate coordinate) {
        MessageMetadataType message = new MessageMetadataTypeBuilder().payload(this.getOutputPayload(operation, coordinate)).build();
        return new MuleEventMetadataTypeBuilder().message(message).addVariable("outboundHeaders", (MetadataType)this.getOutputHeaders(operation).build()).addVariable("httpStatus", MetadataFactory.stringMetadata()).build();
    }

    private MetadataType getInputPayload(Operation operation, ApiCoordinate coordinate) {
        Request request = operation.request();
        if (request == null) {
            return MetadataFactory.defaultMetadata();
        }
        List payloads = request.payloads();
        Optional<Payload> payload = FlowMetadata.findPayload(payloads, coordinate.getMediaType());
        return payload.map(p -> this.metadata((Payload)p, coordinate, "input")).orElseGet(MetadataFactory::defaultMetadata);
    }

    private MetadataType getOutputPayload(Operation operation, ApiCoordinate coordinate) {
        Optional<Response> response = FlowMetadata.findFirstResponse(operation);
        if (!response.isPresent()) {
            return MetadataFactory.defaultMetadata();
        }
        List payloads = response.get().payloads();
        Optional<Payload> payload = FlowMetadata.findPayload(payloads, coordinate.getMediaType());
        return payload.map(p -> this.metadata((Payload)p, coordinate, "output")).orElseGet(MetadataFactory::defaultMetadata);
    }

    private ObjectTypeBuilder getOutputHeaders(Operation operation) {
        List<Parameter> headers = FlowMetadata.findFirstResponse(operation).map(Response::headers).orElse(Collections.emptyList());
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        headers.forEach(header -> builder.addField().key(header.name().value().toLowerCase()).value(this.metadata((Parameter)header)).required(header.required().value()));
        return builder;
    }

    private ObjectType getInputAttributes(Operation operation, Map<String, Parameter> baseUrParameters) {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_CLIENT_CERTIFICATE.getName()).required(false).value(FlowMetadata.getClientCertificate());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_HEADERS.getName()).required(true).value((TypeBuilder)this.getInputHeaders(operation));
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_LISTENER_PATH.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_METHOD.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_QUERY_PARAMS.getName()).required(true).value((TypeBuilder)this.getQueryParameters(operation));
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_QUERY_STRING.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_RELATIVE_PATH.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_REMOTE_ADDRESS.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_REQUEST_PATH.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_REQUEST_URI.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_SCHEME.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_URI_PARAMS.getName()).required(true).value((TypeBuilder)this.getUriParameters(this.endPoint, baseUrParameters));
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_VERSION.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_LOCAL_ADDRESS.getName()).required(true).value(MetadataFactory.stringMetadata());
        return builder.build();
    }

    private ObjectTypeBuilder getInputHeaders(Operation operation) {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        Request request = operation.request();
        if (request != null) {
            request.headers().forEach(header -> builder.addField().key(header.name().value()).value(this.metadata((Parameter)header)).required(header.required().value()));
        }
        return builder;
    }

    private static MetadataType getClientCertificate() {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        builder.addField().key(CertificateFields.CLIENT_CERTIFICATE_PUBLIC_KEY.getName()).value(MetadataFactory.objectMetadata());
        builder.addField().key(CertificateFields.CLIENT_CERTIFICATE_TYPE.getName()).value(MetadataFactory.stringMetadata());
        builder.addField().key(CertificateFields.CLIENT_CERTIFICATE_ENCODED.getName()).value(MetadataFactory.binaryMetadata());
        return builder.build();
    }

    private ObjectTypeBuilder getUriParameters(EndPoint endPoint, Map<String, Parameter> baseUriParameters) {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        baseUriParameters.forEach((name, param) -> builder.addField().key(name).value(this.metadata((Parameter)param)).required(param.required().value()));
        this.addFields(builder, endPoint);
        return builder;
    }

    private ObjectTypeBuilder getQueryParameters(Operation operation) {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        Request request = operation.request();
        if (request != null) {
            request.queryParameters().forEach(param -> builder.addField().key(param.name().value()).value(this.metadata((Parameter)param)).required(param.required().value()));
        }
        return builder;
    }

    private void addFields(ObjectTypeBuilder builder, EndPoint endPoint) {
        List parameters = endPoint.parameters();
        if (!parameters.isEmpty()) {
            parameters.forEach(p -> builder.addField().key(p.name().value()).value(this.metadata((Parameter)p)).required(p.required().value()));
        }
    }

    private static Optional<Response> findFirstResponse(Operation operation) {
        return FlowMetadata.getResponse(operation, STATUS_CODE_200);
    }

    private static Optional<Response> getResponse(Operation operation, String statusCode) {
        return operation.responses().stream().filter(response -> statusCode.equals(response.statusCode().value()) && !response.payloads().isEmpty()).findFirst();
    }

    private static Optional<Payload> findPayload(List<Payload> payloads, String mediaType) {
        if (payloads.isEmpty()) {
            return Optional.empty();
        }
        return payloads.size() == 1 || mediaType == null ? Optional.of(payloads.get(0)) : payloads.stream().filter(p -> p.mediaType().value().equalsIgnoreCase(mediaType)).findFirst();
    }

    private MetadataType metadata(Parameter parameter) {
        try {
            return MetadataFactory.from(parameter.schema());
        }
        catch (Exception e) {
            this.notifier.warn(String.format("Error while trying to resolve metadata for parameter '%s'\nDetails: %s", parameter.name(), e.getMessage()));
            return MetadataFactory.defaultMetadata(parameter.schema());
        }
    }

    private MetadataType metadata(Payload payload, ApiCoordinate coordinate, String payloadDescription) {
        try {
            return MetadataFactory.from(payload.schema());
        }
        catch (Exception e) {
            this.notifier.warn(String.format("Error while trying to resolve %s payload metadata for flow '%s'.\nDetails: %s", payloadDescription, coordinate.getFlowName(), e.getMessage()));
            return MetadataFactory.defaultMetadata(payload.schema());
        }
    }
}

