/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.module.apikit.metadata.AbstractMetadataTestCase;

@RunWith(value=Parameterized.class)
@Ignore
public class MetadataCompatibilityTestCase
extends AbstractMetadataTestCase {
    private File app;
    private String flow;

    public MetadataCompatibilityTestCase(File app, String flow) {
        this.app = app;
        this.flow = flow;
    }

    @Test
    public void compatibilityMetadata() {
        File javaGoldenFile = this.goldenFile(this.flow, this.app, "RAML");
        File amfGoldenFile = this.goldenFile(this.flow, this.app, "AMF");
        String javaMetadata = MetadataCompatibilityTestCase.readFile(javaGoldenFile.toPath());
        String amfMetadata = MetadataCompatibilityTestCase.readFile(amfGoldenFile.toPath());
        Assert.assertThat((String)String.format("Java/AMF metadata differ. App: '%s' Flow: '%s'", this.app.getParentFile().getName(), this.flow), (Object)javaMetadata, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)amfMetadata)));
    }

    @Parameterized.Parameters(name="{0}-{2}")
    public static Collection<Object[]> getData() throws IOException, URISyntaxException {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        MetadataCompatibilityTestCase.scanApps().forEach(app -> {
            try {
                String folderName = app.getParentFile().getName();
                MetadataCompatibilityTestCase.findFlows(app).forEach(flow -> parameters.add(new Object[]{folderName, app, flow}));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return parameters;
    }
}

