/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.metadata.api.model.FunctionType;
import org.mule.module.apikit.metadata.AbstractMetadataTestCase;
import org.mule.runtime.apikit.metadata.api.MetadataBuilder;
import org.mule.runtime.apikit.metadata.api.MetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class MetadataTestCase
extends AbstractMetadataTestCase {
    private final String parser;
    private final File app;
    private final boolean generateFixedFiles = false;

    public MetadataTestCase(String parser, File app) {
        this.parser = parser;
        this.app = app;
    }

    @Before
    public void beforeTest() {
        System.setProperty("mule.apikit.parser", this.parser);
    }

    @After
    public void afterTest() {
        System.clearProperty("mule.apikit.parser");
    }

    @Test
    public void checkMetadata() throws Exception {
        if (this.app.getAbsolutePath().contains("oas") && this.parser.equals("RAML")) {
            return;
        }
        for (String flow : MetadataTestCase.findFlows(this.app)) {
            File goldenFile = this.goldenFile(flow, this.app, this.parser);
            ArtifactAst applicationModel = MetadataTestCase.createApplicationModel(this.app);
            Assert.assertThat((Object)applicationModel, (Matcher)CoreMatchers.notNullValue());
            MetadataService service = (MetadataService)this.getService(MetadataService.class);
            MetadataBuilder apikitMetadataBuilder = service.getApikitMetadataBuilder();
            Optional<FunctionType> metadata = MetadataTestCase.getMetadata(apikitMetadataBuilder, applicationModel, flow);
            if (this.isInvalidFileLocation()) {
                Assert.assertThat((Object)metadata.isPresent(), (Matcher)CoreMatchers.is((Object)false));
                return;
            }
            Assert.assertThat((Object)metadata.isPresent(), (Matcher)CoreMatchers.is((Object)true));
            String current = MetadataTestCase.metadataToString(this.parser, metadata.get()).trim();
            Path goldenPath = goldenFile.exists() ? goldenFile.toPath() : MetadataTestCase.createGoldenFile(goldenFile, current);
            String expected = MetadataTestCase.readFile(goldenPath).trim();
            try {
                Assert.assertThat((String)("Metadata differ from expected on flow: " + flow + ". File: " + this.relativePath(goldenFile)), (Object)current, (Matcher)CoreMatchers.is((Object)expected));
            }
            catch (AssertionError error) {
                String name = goldenFile.getName();
                File folder = goldenFile.getParentFile();
                throw error;
            }
        }
    }

    private String relativePath(File goldenFile) {
        try {
            File base = new File(((Object)((Object)this)).getClass().getClassLoader().getResource("").toURI());
            return base.toURI().relativize(goldenFile.toURI()).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Parameterized.Parameters(name="{0} -> {1}")
    public static Collection<Object[]> getData() throws IOException, URISyntaxException {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        MetadataTestCase.scanApps().forEach(app -> {
            try {
                parameters.add(new Object[]{"RAML", app});
                parameters.add(new Object[]{"AMF", app});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return parameters;
    }

    private boolean isInvalidFileLocation() {
        return this.app.getPath().contains("invalid-raml-file-location");
    }
}

