/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.utils;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.mule.runtime.dsl.api.xml.parser.ConfigFile;
import org.mule.runtime.dsl.api.xml.parser.ConfigLine;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader;
import org.mule.runtime.dsl.internal.xml.parser.XmlApplicationParser;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.DefaultHandler;

class MuleAppHelper {
    MuleAppHelper() {
    }

    public static List<XmlNamespaceInfoProvider> discoverNamespaceInfoProviders(ServiceRegistry serviceRegistry, List<ClassLoader> pluginsClassLoaders) {
        ImmutableList.Builder namespaceInfoProvidersBuilder = ImmutableList.builder();
        namespaceInfoProvidersBuilder.addAll((Iterable)serviceRegistry.lookupProviders(XmlNamespaceInfoProvider.class, Thread.currentThread().getContextClassLoader()));
        pluginsClassLoaders.forEach(pluginClassLoader -> namespaceInfoProvidersBuilder.addAll((Iterable)serviceRegistry.lookupProviders(XmlNamespaceInfoProvider.class, pluginClassLoader)));
        return namespaceInfoProvidersBuilder.build();
    }

    public static Optional<ConfigLine> loadConfigLines(InputStream inputStream) {
        SpiServiceRegistry serviceRegistry = new SpiServiceRegistry();
        Document document = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(SAXParserFactory::newInstance, "config", inputStream, (EntityResolver)new DefaultHandler());
        XmlApplicationParser xmlApplicationParser = new XmlApplicationParser(MuleAppHelper.discoverNamespaceInfoProviders((ServiceRegistry)serviceRegistry, Collections.emptyList()));
        return xmlApplicationParser.parse(document.getDocumentElement());
    }

    public static ArtifactAst loadApplicationModel(ConfigLine configLine, String fileName) throws Exception {
        ConfigFile configFile = new ConfigFile(fileName, Collections.singletonList(configLine));
        ArtifactConfig artifactConfig = new ArtifactConfig.Builder().addConfigFile(configFile).build();
        return MuleAppHelper.loadApplicationModel(artifactConfig, Collections.emptySet(), Optional.of(new ComponentBuildingDefinitionRegistry()), s -> {
            throw new UnsupportedOperationException();
        });
    }

    public static ArtifactAst loadApplicationModel(ArtifactConfig artifactConfig, Set<ExtensionModel> extensionModels, Optional<ComponentBuildingDefinitionRegistry> componentBuildingDefinitionRegistry, ResourceProvider externalResourceProvider) throws Exception {
        return new ApplicationModel(artifactConfig, null, extensionModels, Collections.emptyMap(), Optional.empty(), componentBuildingDefinitionRegistry, externalResourceProvider);
    }

    static Optional<ArtifactAst> createInternalApplicationModel(String name, InputStream inputStream) {
        return MuleAppHelper.loadConfigLines(inputStream).map(configLine -> {
            try {
                return MuleAppHelper.loadApplicationModel(configLine, name);
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
    }
}

