/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import amf.client.model.StrField;
import amf.client.model.domain.AnyShape;
import amf.client.model.domain.EndPoint;
import amf.client.model.domain.NodeShape;
import amf.client.model.domain.Operation;
import amf.client.model.domain.Parameter;
import amf.client.model.domain.Payload;
import amf.client.model.domain.Request;
import amf.client.model.domain.Shape;
import amf.client.model.domain.WebApi;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.amf.impl.AMFParser;
import org.mule.apikit.model.api.ApiReference;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.mule.metadata.json.api.JsonTypeLoader;

@Ignore
public class AmfTestCase {
    @Test
    public void endPointsRaml10() {
        WebApi apiModel = AmfTestCase.webApi(AmfTestCase.resource("uri-params-in-raml10/api.raml"));
        List endPoints = apiModel.endPoints();
        MatcherAssert.assertThat((String)"Number of EndPoints differs.", (Object)endPoints.size(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)4)));
        MatcherAssert.assertThat((Object)((EndPoint)endPoints.get(0)).path().value(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)"/part")));
        MatcherAssert.assertThat((Object)((EndPoint)endPoints.get(1)).path().value(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)"/part/{uriParam1}")));
        MatcherAssert.assertThat((Object)((EndPoint)endPoints.get(2)).path().value(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)"/part/{uriParam1}/{uriParam2}")));
        MatcherAssert.assertThat((Object)((EndPoint)endPoints.get(3)).path().value(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)"/part/{uriParam1}/{uriParam2}/{uriParam3}")));
        List parameters = ((EndPoint)endPoints.get(2)).parameters();
        MatcherAssert.assertThat((Object)parameters.size(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)2)));
        MatcherAssert.assertThat((Object)((Parameter)parameters.get(0)).name().value(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)"uriParam1")));
        MatcherAssert.assertThat((Object)((Parameter)parameters.get(1)).name().value(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)"uriParam2")));
        parameters = ((EndPoint)endPoints.get(3)).parameters();
        MatcherAssert.assertThat((Object)parameters.size(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)3)));
        MatcherAssert.assertThat((Object)((Parameter)parameters.get(0)).name().value(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)"uriParam1")));
        MatcherAssert.assertThat((Object)((Parameter)parameters.get(1)).name().value(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)"uriParam2")));
        MatcherAssert.assertThat((Object)((Parameter)parameters.get(2)).name().value(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)"uriParam3")));
    }

    @Test
    public void queryParamsRaml08() {
        WebApi apiModel = AmfTestCase.webApi(AmfTestCase.resource("query-params-in-raml08/api.raml"));
        List endPoints = apiModel.endPoints();
        endPoints.forEach(endPoint -> endPoint.operations().forEach(operation -> {
            Request request = operation.request();
            if (request != null) {
                request.queryParameters().forEach(parameter -> {
                    Shape schema = parameter.schema();
                    if (schema instanceof AnyShape) {
                        try {
                            String jsonSchema = ((AnyShape)schema).buildJsonSchema();
                            System.out.println("Parameter " + parameter.name() + ":");
                            System.out.println(jsonSchema);
                            System.out.println();
                            JsonTypeLoader typeLoader = new JsonTypeLoader(jsonSchema);
                            Optional metadataType = typeLoader.load(null);
                            String metadata = new MetadataTypeWriter().toString((MetadataType)metadataType.get());
                            System.out.println(metadata);
                            System.out.println("--------------------------------------------------------------\n");
                        }
                        catch (Throwable e) {
                            System.out.println("Fall\u00c3\u00b3 la obtencion de JsonSchema de " + schema.name() + " " + schema.getClass() + "\n" + e.getMessage());
                        }
                    }
                });
            }
        }));
    }

    @Test
    public void jsonSchemaFromMultipartRaml08() {
        WebApi webApi = AmfTestCase.webApi(AmfTestCase.resource("api-in-raml08/api.raml"));
        Optional<Operation> op = AmfTestCase.findOperation(webApi, "/multipart", "post");
        MatcherAssert.assertThat((Object)op.isPresent(), (Matcher)Is.is((Object)true));
        op.ifPresent(operation -> {
            Request request = operation.request();
            MatcherAssert.assertThat((Object)request, (Matcher)CoreMatchers.notNullValue());
            List payloads = request.payloads();
            MatcherAssert.assertThat((Object)payloads.size(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)1)));
            Payload payload = (Payload)payloads.get(0);
            Shape schema = payload.schema();
            if (schema instanceof AnyShape) {
                List properties = ((NodeShape)schema).properties();
                properties.forEach(p -> System.out.println(p.name()));
            }
        });
    }

    @Test
    public void jsonSchemaFromFileRaml10() {
        WebApi apiModel = AmfTestCase.webApi(AmfTestCase.resource("query-params-in-raml10/api.raml"));
        List endPoints = apiModel.endPoints();
        endPoints.forEach(endPoint -> endPoint.operations().forEach(operation -> {
            Request request = operation.request();
            if (request != null) {
                request.queryParameters().forEach(parameter -> {
                    Shape schema = parameter.schema();
                    if (schema instanceof AnyShape) {
                        try {
                            String string = ((AnyShape)schema).buildJsonSchema();
                        }
                        catch (Throwable e) {
                            System.out.println("Error getting JsonSchema for " + schema.name() + " " + schema.getClass() + "\n" + e.getMessage());
                        }
                    }
                });
            }
        }));
    }

    @Test
    public void remoteRaml10() throws URISyntaxException {
        URI uri = new URI("https://raw.githubusercontent.com/mulesoft/apikit/M4-1.x/mule-apikit-module/src/test/resources/org/mule/module/apikit/router-remote-raml/remote.raml");
        AmfTestCase.webApi(uri.toString());
    }

    @Test
    public void queryParamsOrderRaml08() {
        WebApi webApi = AmfTestCase.webApi(AmfTestCase.resource("sanity-test/api.raml"));
        Optional<Operation> op = AmfTestCase.findOperation(webApi, "/clients", "get");
        MatcherAssert.assertThat((Object)op.isPresent(), (Matcher)Is.is((Object)true));
        op.ifPresent(operation -> {
            Request request = operation.request();
            MatcherAssert.assertThat((Object)request, (Matcher)CoreMatchers.notNullValue());
            List<String> parameters = request.queryParameters().stream().map(o -> o.name().value()).collect(Collectors.toList());
            MatcherAssert.assertThat((Object)AmfTestCase.mkString(parameters), (Matcher)CoreMatchers.equalTo((Object)"code,size,color,description"));
        });
    }

    @Test
    public void clientsMetadataRaml08() {
        WebApi webApi = AmfTestCase.webApi(AmfTestCase.resource("sanity-test/api.raml"));
        Optional<Operation> op = AmfTestCase.findOperation(webApi, "/clients", "get");
        MatcherAssert.assertThat((Object)op.isPresent(), (Matcher)Is.is((Object)true));
        AmfTestCase.dump(op.get());
        op.ifPresent(operation -> {
            List responses = operation.responses();
            responses.forEach(response -> {
                List payloads = response.payloads();
                payloads.forEach(payload -> {
                    Shape schema = payload.schema();
                    MatcherAssert.assertThat((Object)schema, (Matcher)CoreMatchers.notNullValue());
                });
            });
        });
    }

    private static void dump(Operation operation) {
        List<String> ct = operation.contentType().stream().map(StrField::value).collect(Collectors.toList());
        System.out.println("\tOperation: " + operation.method().value() + " contentTypes:" + AmfTestCase.mkString(ct));
        Request request = operation.request();
        if (request != null) {
            System.out.println("\t\tRequest:");
            if (!request.queryParameters().isEmpty()) {
                List<String> params = request.queryParameters().stream().map(o -> o.name().value()).collect(Collectors.toList());
                System.out.println("\t\t\tqueryParameters=" + AmfTestCase.mkString(params));
            }
        }
        System.out.println("\t\tRequest:");
        List responses = operation.responses();
        responses.forEach(response -> {
            List payloads = response.payloads();
            payloads.forEach(payload -> {
                Shape schema = payload.schema();
                MatcherAssert.assertThat((Object)schema, (Matcher)CoreMatchers.notNullValue());
                if (schema instanceof AnyShape) {
                    AnyShape anyShape = (AnyShape)schema;
                    System.out.println("\t\t\tJsonSchema:\n" + anyShape.buildJsonSchema());
                    List examples = anyShape.examples();
                    System.out.println("\t\t\tExamples:");
                    examples.forEach(example -> {
                        System.out.println("\t\t\t\t" + example.value().value());
                        System.out.println();
                    });
                }
            });
        });
    }

    private static Optional<Operation> findOperation(WebApi webApi, String path, String method) {
        return webApi.endPoints().stream().filter(e -> e.path().value().equals(path)).findFirst().flatMap(endPoint -> endPoint.operations().stream().filter(operation -> operation.method().value().equalsIgnoreCase(method)).findFirst());
    }

    private static String mkString(List<String> list) {
        return list.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    private static WebApi webApi(String path) {
        ApiReference apiRef = ApiReference.create((String)path);
        AMFParser parserWrapper = new AMFParser(apiRef, true);
        WebApi webApi = parserWrapper.getWebApi();
        MatcherAssert.assertThat((Object)webApi, (Matcher)CoreMatchers.notNullValue());
        return webApi;
    }

    private static String resource(String resource) {
        URL url = AmfTestCase.class.getResource(resource);
        try {
            URI uri = url.toURI();
            return uri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error getting URI from resource" + resource, e);
        }
    }
}

