/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.model;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.module.apikit.metadata.internal.model.Flow;
import org.mule.module.apikit.metadata.internal.model.FlowMapping;

public class ApiCoordinateFactory {
    private Set<String> configNames;

    public ApiCoordinateFactory(Set<String> configNames) {
        this.configNames = configNames;
    }

    public Optional<ApiCoordinate> fromFlowName(String flowName) {
        String[] parts = Flow.decode(flowName).split(":");
        if (parts.length < 2 || parts.length > 4) {
            return Optional.empty();
        }
        ApiCoordinateBuilder builder = ApiCoordinateBuilder.create(flowName, parts, this.configNames);
        return builder.build();
    }

    public ApiCoordinate createFromFlowMapping(FlowMapping mapping) {
        String flowName = mapping.getFlowRef();
        String configName = mapping.getConfigName();
        String action = mapping.getAction();
        String resource = mapping.getResource();
        String contentType = mapping.getContentType();
        return new ApiCoordinate(flowName, action, resource, contentType, configName);
    }

    private static class ApiCoordinateBuilder {
        private final String flowName;
        private final String methodName;
        private final String resourceName;
        private String mediaType = null;
        private String configName = null;
        private Set<String> configNames = Collections.emptySet();

        private ApiCoordinateBuilder(String flowName, String methodName, String resourceName) {
            this.flowName = flowName;
            this.methodName = methodName;
            this.resourceName = resourceName;
        }

        static ApiCoordinateBuilder create(String flowName, String[] parts, Set<String> configNames) {
            ApiCoordinateBuilder builder = new ApiCoordinateBuilder(flowName, parts[0], parts[1]);
            if (parts.length == 3) {
                if (configNames.contains(parts[2])) {
                    builder.withConfigName(parts[2]);
                } else {
                    builder.withMediaType(parts[2]);
                }
            } else if (parts.length == 4) {
                builder.withMediaType(parts[2]).withConfigName(parts[3]);
            }
            builder.withConfigNames(configNames);
            return builder;
        }

        ApiCoordinateBuilder withMediaType(String value) {
            this.mediaType = value;
            return this;
        }

        ApiCoordinateBuilder withConfigName(String value) {
            this.configName = value;
            return this;
        }

        ApiCoordinateBuilder withConfigNames(Set<String> configNames) {
            this.configNames = configNames;
            return this;
        }

        private Optional<ApiCoordinate> build() {
            ApiCoordinate coord = new ApiCoordinate(this.flowName, this.methodName, this.resourceName, this.mediaType, this.configName);
            if (coord.getConfigName() != null && !this.configNames.contains(coord.getConfigName()) || this.configNames.size() > 1 && coord.getConfigName() == null) {
                return Optional.empty();
            }
            return Optional.of(coord);
        }
    }
}

