/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

public class MetadataTypeWriter {
    private static final String TYPE_SUFIX = "Type";
    private static final String DEFAULT_PREFIX = "Default";
    private static final String NULL_STRING = "null";
    private StringBuilder content = new StringBuilder();
    private int indent = 0;
    private Stack<MetadataType> typeStack = new Stack();

    public String toString(MetadataType structure) {
        Optional label = structure.getMetadataFormat().getLabel();
        String stringLabel = label.isPresent() ? (String)label.get() : NULL_STRING;
        this.content.append("%type").append(" ").append("_").append(":").append(stringLabel).append(" = ");
        this.write(structure);
        return this.content.toString();
    }

    private void write(MetadataType structure) {
        if (this.typeStack.contains(structure)) {
            int indexOf = this.typeStack.indexOf(structure);
            int reference = this.typeStack.size() - indexOf;
            String ref = "#";
            for (int i = 0; i < reference; ++i) {
                if (i > 0) {
                    ref = ref + "/";
                }
                ref = ref + "..";
            }
            this.content.append(ref);
        } else {
            this.typeStack.push(structure);
            if (!structure.getAnnotations().isEmpty()) {
                this.writeAnnotation(structure.getAnnotations());
            }
            structure.accept(new MetadataTypeVisitor(){

                public void visitSimpleType(SimpleType structure) {
                    MetadataTypeWriter.this.writeBasicType(structure);
                }

                public void visitIntersection(IntersectionType structure) {
                    MetadataTypeWriter.this.writeIntersectionType(structure);
                }

                public void visitUnion(UnionType structure) {
                    MetadataTypeWriter.this.writeUnion(structure);
                }

                public void visitTuple(TupleType structure) {
                    MetadataTypeWriter.this.writeTuple(structure);
                }

                public void visitArrayType(ArrayType structure) {
                    MetadataTypeWriter.this.writeArray(structure);
                }

                public void visitObject(ObjectType structure) {
                    MetadataTypeWriter.this.writeObject(structure);
                }

                public void visitFunction(FunctionType functionType) {
                    MetadataTypeWriter.this.writeFunction(functionType);
                }

                public void defaultVisit(MetadataType metadataType) {
                    MetadataTypeWriter.this.content.append(MetadataTypeWriter.this.getName(metadataType));
                }
            });
            this.typeStack.pop();
        }
    }

    private void writeFunction(FunctionType functionType) {
        this.content.append("(");
        boolean first = true;
        for (FunctionParameter functionParameter : functionType.getParameters()) {
            if (!first) {
                this.content.append(",");
            }
            this.content.append(functionParameter.getName());
            if (functionParameter.isOptional()) {
                this.writeOptional();
            }
            this.content.append(":");
            this.write(functionParameter.getType());
            first = false;
        }
        this.content.append(")");
        this.content.append(" -> ");
        if (functionType.getReturnType().isPresent()) {
            this.write((MetadataType)functionType.getReturnType().get());
        } else {
            this.content.append("void");
        }
    }

    private void writeBasicType(SimpleType structure) {
        String name = this.getName((MetadataType)structure);
        this.content.append(name);
    }

    private String getName(MetadataType structure) {
        String simpleName;
        String name = simpleName = structure.getClass().getSimpleName();
        if (simpleName.endsWith(TYPE_SUFIX)) {
            name = name.substring(0, simpleName.length() - TYPE_SUFIX.length());
        }
        if (simpleName.startsWith(DEFAULT_PREFIX)) {
            name = name.substring(DEFAULT_PREFIX.length());
        }
        return name;
    }

    private void writeAnnotation(Collection<TypeAnnotation> annotations) {
        for (TypeAnnotation annotation : annotations) {
            this.content.append("@").append(annotation.getName()).append("");
            List instanceFields = Arrays.asList(annotation.getClass().getDeclaredFields()).stream().filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList());
            if (!instanceFields.isEmpty()) {
                this.content.append("(");
                boolean first = true;
                for (Field instanceField : instanceFields) {
                    try {
                        Object fieldValue = this.getFieldValue(annotation, instanceField);
                        if (fieldValue instanceof Optional) {
                            if (!((Optional)fieldValue).isPresent()) continue;
                            Object propertyValue = ((Optional)fieldValue).get();
                            first = this.writeAnnotationPropertyValue(first, instanceField, propertyValue);
                            continue;
                        }
                        if (fieldValue == null) continue;
                        first = this.writeAnnotationPropertyValue(first, instanceField, fieldValue);
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                this.content.append(")");
            }
            this.content.append(" ");
        }
    }

    private boolean writeAnnotationPropertyValue(boolean first, Field instanceField, Object propertyValue) {
        if (!first) {
            this.writeFieldSeparator();
        }
        this.content.append("\"").append(instanceField.getName()).append("\"").append(" : ");
        this.writeValue(propertyValue);
        return false;
    }

    private void writeValue(Object propertyValue) {
        if (propertyValue instanceof Object[]) {
            int length = Array.getLength(propertyValue);
            this.content.append("[");
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    this.content.append(",");
                }
                this.writeValue(Array.get(propertyValue, i));
            }
            this.content.append("]");
        } else if (propertyValue instanceof String) {
            this.content.append("\"").append(propertyValue.toString()).append("\"");
        } else {
            this.content.append(String.valueOf(propertyValue));
        }
    }

    private Object getFieldValue(TypeAnnotation annotation, Field annotationField) throws IllegalAccessException {
        annotationField.setAccessible(true);
        return annotationField.get(annotation);
    }

    private void writeUnion(UnionType unionType) {
        List types = unionType.getTypes();
        this.writeTypesSeparatedBy(types, " | ");
    }

    private void writeTypesSeparatedBy(List<MetadataType> types, String separator) {
        for (int i = 0; i < types.size(); ++i) {
            if (i > 0) {
                this.content.append(separator);
            }
            this.indent();
            this.write(types.get(i));
            this.dedent();
        }
    }

    private void writeIntersectionType(IntersectionType intersectionType) {
        List types = intersectionType.getTypes();
        this.writeTypesSeparatedBy(types, " & ");
    }

    private void writeTuple(TupleType structure) {
        this.writeTypes(structure.getTypes());
    }

    private void writeTypes(List<MetadataType> types) {
        this.content.append("<");
        int i = 0;
        for (MetadataType type : types) {
            this.indent();
            if (i > 0) {
                this.writeFieldSeparator();
            }
            this.write(type);
            this.dedent();
            ++i;
        }
        this.content.append(">");
    }

    private void writeArray(ArrayType structure) {
        this.content.append("[");
        this.indent();
        this.write(structure.getType());
        this.dedent();
        this.content.append("]");
    }

    private void newLine() {
        this.content.append("\n");
    }

    private void writeObject(ObjectType objectType) {
        if (objectType.isOrdered()) {
            this.content.append("{");
        }
        this.content.append("{");
        this.indent();
        this.newLine();
        Collection fields = objectType.getFields();
        int i = 0;
        for (ObjectFieldType field : fields) {
            if (i > 0) {
                this.writeFieldSeparator();
                this.newLine();
            }
            this.writeIndent();
            this.writeAnnotation(field.getAnnotations());
            ObjectKeyType key = field.getKey();
            if (key.isName()) {
                this.writeName(key.getName());
            } else if (key.isPattern()) {
                this.writePattern(key.getPattern());
            }
            if (!field.isRequired()) {
                this.writeOptional();
            }
            if (field.isRepeated()) {
                this.content.append("*");
            }
            this.writeAttributes(key);
            this.writeKeyValueSeparator();
            this.write(field.getValue());
            ++i;
        }
        Optional openRestriction = objectType.getOpenRestriction();
        if (openRestriction.isPresent()) {
            if (!fields.isEmpty()) {
                this.writeFieldSeparator();
                this.newLine();
            }
            this.writeIndent();
            this.content.append("*");
            this.writeKeyValueSeparator();
            this.write((MetadataType)openRestriction.get());
        }
        this.dedent();
        this.newLine();
        this.writeIndent();
        this.content.append("}");
        if (objectType.isOrdered()) {
            this.content.append("}");
        }
    }

    private void writeOptional() {
        this.content.append("?");
    }

    private StringBuilder writeKeyValueSeparator() {
        return this.content.append(" : ");
    }

    private void writeAttributes(ObjectKeyType key) {
        Collection attributes = key.getAttributes();
        if (!attributes.isEmpty()) {
            this.content.append(" @(");
            int e = 0;
            for (AttributeFieldType attribute : attributes) {
                AttributeKeyType attributeKey;
                if (e > 0) {
                    this.writeFieldSeparator();
                }
                if ((attributeKey = attribute.getKey()).isName()) {
                    this.writeName(attributeKey.getName());
                } else if (attributeKey.isPattern()) {
                    this.writePattern(attributeKey.getPattern());
                }
                if (!attribute.isRequired()) {
                    this.writeOptional();
                }
                this.writeKeyValueSeparator();
                this.write(attribute.getValue());
                ++e;
            }
            this.content.append(")");
        }
    }

    private void writeFieldSeparator() {
        this.content.append(", ");
    }

    private void writePattern(Pattern pattern) {
        this.content.append("/");
        this.content.append(pattern.toString());
        this.content.append("/");
    }

    private void writeName(QName name) {
        if (name == null) {
            return;
        }
        this.content.append("\"");
        this.content.append(new QName(name.getNamespaceURI(), name.getLocalPart().replace("{", "{{").replace("}", "}}")));
        this.content.append("\"");
    }

    private void dedent() {
        --this.indent;
    }

    private void indent() {
        ++this.indent;
    }

    private void writeIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.content.append("  ");
        }
    }
}

