/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.module.apikit.metadata.utils.MetadataFixer;
import org.mule.module.apikit.metadata.utils.MetadataTypeWriter;
import org.mule.module.apikit.metadata.utils.MockedApplicationModel;
import org.mule.module.apikit.metadata.utils.TestNotifier;
import org.mule.module.apikit.metadata.utils.TestResourceLoader;
import org.mule.runtime.apikit.metadata.api.Metadata;
import org.mule.runtime.apikit.metadata.api.MetadataBuilder;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.core.api.extension.ExtensionManager;

public abstract class AbstractMetadataTestCase
extends MuleArtifactFunctionalTestCase {
    protected static final String AMF = "AMF";
    protected static final String RAML = "RAML";
    private static final PathMatcher API_MATCHER = FileSystems.getDefault().getPathMatcher("glob:app.xml");

    protected static List<File> scanApps() throws IOException, URISyntaxException {
        URI baseFolder = new File(AbstractMetadataTestCase.class.getResource("/anchor.test.resource.file").toURI()).getParentFile().toURI();
        return AbstractMetadataTestCase.scan(baseFolder);
    }

    protected String getConfigFile() {
        return "mule-config.xml";
    }

    protected static List<File> scan(URI resources) throws IOException {
        return Files.walk(Paths.get(resources), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && API_MATCHER.matches(path.getFileName())).map(Path::toFile).collect(Collectors.toList());
    }

    protected static ArtifactAst createApplicationModel(File app, ExtensionManager extensionManager) throws Exception {
        MockedApplicationModel mockedApplicationModel = new MockedApplicationModel.Builder().addConfig(app).extensionManager(extensionManager).build();
        return mockedApplicationModel.getMuleApplicationModel();
    }

    protected static List<String> findFlows(File app, ExtensionManager extensionManager) throws Exception {
        ArtifactAst applicationModel = AbstractMetadataTestCase.createApplicationModel(app, extensionManager);
        return applicationModel.topLevelComponentsStream().filter(componentAst -> componentAst.getIdentifier().getNamespace().equals("mule") && componentAst.getIdentifier().getName().equals("flow")).map(componentAst -> (String)componentAst.getParameter("General", "name").getValue().getRight()).filter(flow -> AbstractMetadataTestCase.isApikitFlow(flow)).collect(Collectors.toList());
    }

    private static boolean isApikitFlow(String name) {
        return name.startsWith("get:") || name.startsWith("post:") || name.startsWith("put:") || name.startsWith("delete:") || name.startsWith("head:") || name.startsWith("patch:") || name.startsWith("options:") || name.startsWith("trace:") || name.startsWith("connect:");
    }

    protected static Optional<FunctionType> getMetadata(MetadataBuilder metadataBuilder, ArtifactAst applicationModel, String flow) {
        Metadata metadata = metadataBuilder.withApplicationModel(applicationModel).withResourceLoader((ResourceLoader)new TestResourceLoader()).withNotifier((Notifier)new TestNotifier()).build();
        return metadata.getMetadataForFlow(flow);
    }

    protected static String metadataToString(String parser, FunctionType functionType) {
        String result = new MetadataTypeWriter().toString((MetadataType)functionType);
        return AMF.equals(parser) ? MetadataFixer.normalizeEnums(result) : result;
    }

    protected File goldenFile(String flow, File app, String parser) {
        String fileName = flow.replace("\\", "").replace(":", "-") + ".out";
        File parserFolder = new File(app.getParentFile(), parser.toLowerCase());
        return new File(parserFolder, fileName);
    }

    protected static String readFile(Path path) {
        try {
            return new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Path createGoldenFile(File goldenFile, String content) throws IOException {
        String srcPath = goldenFile.getPath().replace("target/test-classes", "src/test/resources");
        Path goldenPath = Paths.get(srcPath, new String[0]);
        System.out.println("*** Create Golden " + goldenPath);
        Path parent = goldenPath.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectory(parent, new FileAttribute[0]);
        }
        return Files.write(goldenPath, content.getBytes("UTF-8"), new OpenOption[0]);
    }
}

