/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.amf;

import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.Parameter;
import amf.apicontract.client.platform.model.domain.Server;
import amf.apicontract.client.platform.model.domain.api.WebApi;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.module.apikit.metadata.internal.amf.FlowMetadata;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.module.apikit.metadata.internal.model.MetadataResolver;
import org.mule.runtime.apikit.metadata.api.MetadataSource;
import org.mule.runtime.apikit.metadata.api.Notifier;

class AmfWrapper
implements MetadataResolver {
    private final Map<String, EndPoint> endPoints;
    private final Map<String, Parameter> baseUriParameters;
    private final Notifier notifier;

    public AmfWrapper(WebApi webApi, Notifier notifier) {
        this.endPoints = webApi.endPoints().stream().collect(Collectors.toMap(endPoint -> this.resolveVersion(endPoint.path().value(), webApi.version().value()), Function.identity()));
        this.baseUriParameters = this.baseUriParameters(webApi);
        this.notifier = notifier;
    }

    private Map<String, Parameter> baseUriParameters(WebApi webApi) {
        List servers = webApi.servers();
        if (servers.isEmpty()) {
            return Collections.emptyMap();
        }
        List variables = ((Server)webApi.servers().get(0)).variables();
        return variables.stream().collect(Collectors.toMap(parameter -> parameter.name().value(), parameter -> parameter));
    }

    @Override
    public Optional<MetadataSource> getMetadataSource(ApiCoordinate coordinate, String httpStatusVar, String outboundHeadersVar) {
        EndPoint endPoint = this.endPoints.get(coordinate.getResource());
        if (endPoint == null) {
            return Optional.empty();
        }
        Optional<Operation> operation = this.operation(endPoint, coordinate);
        return operation.map(op -> new FlowMetadata(endPoint, (Operation)op, coordinate, this.baseUriParameters, this.notifier));
    }

    private Optional<Operation> operation(EndPoint endPoint, ApiCoordinate coordinate) {
        return endPoint.operations().stream().filter(op -> op.method().value().equalsIgnoreCase(coordinate.getMethod())).findFirst();
    }

    public String resolveVersion(String path, String version) {
        return !path.contains("{version}") || StringUtils.isBlank((CharSequence)version) ? path : path.replaceAll("\\{version}", version);
    }
}

