/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.raml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.Resource;
import org.mule.apikit.model.Response;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.module.apikit.metadata.internal.raml.FlowMetadata;
import org.mule.module.apikit.metadata.internal.raml.RamlApiWrapper;
import org.mule.runtime.apikit.metadata.api.Notifier;

public class FlowMetadataTest {
    @Mock
    private RamlApiWrapper api;
    @Mock
    private Action action;
    @Mock
    private ApiCoordinate coordinate;
    @Mock
    private Notifier notifier;
    @Mock
    private Resource resource;
    @Mock
    private Response response;
    @Mock
    private MimeType mimeType;
    private FlowMetadata flowMetadata;
    private Map<String, Parameter> baseUriParameters;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.baseUriParameters = new HashMap<String, Parameter>();
        this.flowMetadata = new FlowMetadata(this.api, this.action, this.coordinate, this.baseUriParameters, "httpStatus", "outboundHeaders", this.notifier);
        Mockito.when((Object)this.action.getResource()).thenReturn((Object)this.resource);
        Mockito.when((Object)this.action.hasBody()).thenReturn((Object)true);
        Mockito.when((Object)this.resource.getResolvedUriParameters()).thenReturn(Collections.emptyMap());
    }

    @Test
    public void testGetMetadata() {
        Mockito.when((Object)this.action.getQueryParameters()).thenReturn(new HashMap());
        Mockito.when((Object)this.action.getHeaders()).thenReturn(new HashMap());
        Mockito.when((Object)this.action.getResponses()).thenReturn(Collections.singletonMap("200", this.response));
        Mockito.when((Object)this.response.getHeaders()).thenReturn(new HashMap());
        Mockito.when((Object)this.response.hasBody()).thenReturn((Object)true);
        Mockito.when((Object)this.response.getBody()).thenReturn(Collections.singletonMap("application/json", this.mimeType));
        Optional result = this.flowMetadata.getMetadata();
        Assertions.assertTrue((boolean)result.isPresent());
        FunctionType functionType = (FunctionType)result.get();
        Assertions.assertEquals((int)1, (int)functionType.getParameters().size());
        Assertions.assertTrue((boolean)(functionType.getReturnType().get() instanceof MuleEventMetadataType));
    }

    @Test
    public void testMetadataWithNoResponses() {
        Mockito.when((Object)this.action.getResponses()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.action.getQueryParameters()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.action.getHeaders()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.coordinate.getMediaType()).thenReturn((Object)"application/json");
        Optional result = this.flowMetadata.getMetadata();
        Assertions.assertTrue((boolean)result.isPresent());
        FunctionType functionType = (FunctionType)result.get();
        MuleEventMetadataType outputEvent = (MuleEventMetadataType)functionType.getReturnType().get();
        Assertions.assertNotNull((Object)outputEvent.getMessageType().getFields());
    }

    @Test
    public void testMetadataWithOneResponse() {
        Mockito.when((Object)this.action.getResponses()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.action.getQueryParameters()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.action.getHeaders()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.coordinate.getMediaType()).thenReturn((Object)"application/json");
        Mockito.when((Object)this.action.getBody()).thenReturn(Collections.singletonMap("application/json", this.mimeType));
        Optional result = this.flowMetadata.getMetadata();
        Assertions.assertTrue((boolean)result.isPresent());
        FunctionType functionType = (FunctionType)result.get();
        MuleEventMetadataType outputEvent = (MuleEventMetadataType)functionType.getReturnType().get();
        Assertions.assertNotNull((Object)outputEvent.getMessageType().getFields());
    }
}

