/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.raml;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.apikit.implv2.v10.model.ParameterImpl;
import org.mule.apikit.model.MimeType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.module.apikit.metadata.internal.raml.MetadataFactory;
import org.mule.module.apikit.metadata.internal.raml.RamlApiWrapper;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class MetadataFactoryTest {
    @Mock
    private RamlApiWrapper api;
    @Mock
    private MimeType mimeType;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testPayloadMetadata_ApplicationJson() {
        Mockito.when((Object)this.mimeType.getType()).thenReturn((Object)"application/json");
        Mockito.when((Object)this.mimeType.getSchema()).thenReturn((Object)"{\"type\": \"object\"}");
        Mockito.when((Object)this.mimeType.getExample()).thenReturn((Object)"{\"key\": \"value\"}");
        MetadataType result = MetadataFactory.payloadMetadata((RamlApiWrapper)this.api, (MimeType)this.mimeType);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void testPayloadMetadata_ApplicationJson_SchemaNull() {
        Mockito.when((Object)this.mimeType.getType()).thenReturn((Object)"application/json");
        Mockito.when((Object)this.mimeType.getExample()).thenReturn((Object)"{\"key\": \"value\"}");
        MetadataType result = MetadataFactory.payloadMetadata((RamlApiWrapper)this.api, (MimeType)this.mimeType);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void testPayloadMetadata_ApplicationJson_EmptyBody() {
        Mockito.when((Object)this.mimeType.getType()).thenReturn((Object)"application/json");
        MetadataType result = MetadataFactory.payloadMetadata((RamlApiWrapper)this.api, (MimeType)this.mimeType);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void testPayloadMetadata_ApplicationXsd() {
        String xmlSchema = "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">  <xs:element name=\"root\">    <xs:complexType>      <xs:sequence>        <xs:element name=\"child\" type=\"xs:string\"/>      </xs:sequence>    </xs:complexType>  </xs:element></xs:schema>";
        Mockito.when((Object)this.mimeType.getType()).thenReturn((Object)"application/xml");
        Mockito.when((Object)this.mimeType.getSchema()).thenReturn((Object)xmlSchema);
        Mockito.when((Object)this.mimeType.getExample()).thenReturn((Object)"<root><child>value</child></root>");
        MetadataType result = MetadataFactory.payloadMetadata((RamlApiWrapper)this.api, (MimeType)this.mimeType);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void testPayloadMetadata_MultipartFormData() {
        String boundary = "----WebKitFormBoundary7MA4YWxkTrZu0gW";
        String multipartSchema = "{\n  \"type\": \"object\",\n  \"properties\": {\n    \"username\": {\"type\": \"string\"},\n    \"email\": {\"type\": \"string\", \"format\": \"email\"},\n    \"profile_picture\": {\"type\": \"string\", \"format\": \"binary\"}\n  },\n  \"required\": [\"username\", \"email\", \"profile_picture\"]\n}";
        String multipartExample = "------" + boundary + "\nContent-Disposition: form-data; name=\"username\"\n\njohn_doe\n------" + boundary + "\nContent-Disposition: form-data; name=\"email\"\n\njohn_doe@example.com\n------" + boundary + "\nContent-Disposition: form-data; name=\"profile_picture\"; filename=\"profile.jpg\"\nContent-Type: image/jpeg\n\n<binary image data>\n------" + boundary + "--";
        Mockito.when((Object)this.mimeType.getType()).thenReturn((Object)"multipart/form-data");
        Mockito.when((Object)this.mimeType.getSchema()).thenReturn((Object)multipartSchema);
        Mockito.when((Object)this.mimeType.getExample()).thenReturn((Object)multipartExample);
        TypeDeclaration usernameTypeDeclaration = (TypeDeclaration)Mockito.mock(TypeDeclaration.class);
        Mockito.when((Object)usernameTypeDeclaration.name()).thenReturn((Object)"username");
        Mockito.when((Object)usernameTypeDeclaration.type()).thenReturn((Object)"string");
        ParameterImpl usernameParameter = new ParameterImpl(usernameTypeDeclaration);
        HashMap<String, List<ParameterImpl>> formParameters = new HashMap<String, List<ParameterImpl>>();
        formParameters.put("username", Collections.singletonList(usernameParameter));
        Mockito.when((Object)this.mimeType.getFormParameters()).thenReturn(formParameters);
        MetadataType result = MetadataFactory.payloadMetadata((RamlApiWrapper)this.api, (MimeType)this.mimeType);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void testPayloadMetadata_ApplicationXml_WithExample() {
        String example = "<root><child>value</child></root>";
        Mockito.when((Object)this.mimeType.getType()).thenReturn((Object)"application/xml");
        Mockito.when((Object)this.mimeType.getSchema()).thenReturn(null);
        Mockito.when((Object)this.mimeType.getExample()).thenReturn((Object)example);
        MetadataType result = MetadataFactory.payloadMetadata((RamlApiWrapper)this.api, (MimeType)this.mimeType);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void testPayloadMetadata_NullBody() {
        Mockito.when((Object)this.mimeType.getType()).thenReturn((Object)"application/unknown");
        MetadataType result = MetadataFactory.payloadMetadata((RamlApiWrapper)this.api, (MimeType)this.mimeType);
        Assertions.assertNotNull((Object)result);
    }
}

