/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mule.metadata.api.model.FunctionType;
import org.mule.module.apikit.metadata.AbstractMetadataTestCase;
import org.mule.runtime.apikit.metadata.api.MetadataBuilder;
import org.mule.runtime.apikit.metadata.api.MetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.core.api.extension.ExtensionManager;

public class MetadataTestCase
extends AbstractMetadataTestCase {
    @Inject
    private ExtensionManager extensionManager;
    private final boolean generateFixedFiles = false;

    @ParameterizedTest
    @MethodSource(value={"getData"})
    @Disabled
    public void checkMetadata(String parser, File app) throws Exception {
        System.setProperty("mule.apikit.parser", parser);
        if (app.getAbsolutePath().contains("oas") && parser.equals("RAML")) {
            return;
        }
        for (String flow : MetadataTestCase.findFlows(app, this.extensionManager)) {
            File goldenFile = this.goldenFile(flow, app, parser);
            ArtifactAst applicationModel = MetadataTestCase.createApplicationModel(app, this.extensionManager);
            Assert.assertThat((Object)applicationModel, (Matcher)CoreMatchers.notNullValue());
            MetadataService service = (MetadataService)this.getService(MetadataService.class);
            MetadataBuilder apikitMetadataBuilder = service.getApikitMetadataBuilder();
            Optional<FunctionType> metadata = MetadataTestCase.getMetadata(apikitMetadataBuilder, applicationModel, flow);
            if (this.isInvalidFileLocation(app)) {
                Assert.assertThat((Object)metadata.isPresent(), (Matcher)CoreMatchers.is((Object)false));
                return;
            }
            Assert.assertThat((Object)metadata.isPresent(), (Matcher)CoreMatchers.is((Object)true));
            String current = MetadataTestCase.metadataToString(parser, metadata.get()).trim();
            Path goldenPath = goldenFile.exists() ? goldenFile.toPath() : MetadataTestCase.createGoldenFile(goldenFile, current);
            String expected = MetadataTestCase.readFile(goldenPath).trim();
            try {
                Assert.assertThat((String)("Metadata differ from expected on flow: " + flow + ". File: " + this.relativePath(goldenFile)), (Object)current, (Matcher)CoreMatchers.is((Object)expected));
            }
            catch (AssertionError error) {
                String name = goldenFile.getName();
                File folder = goldenFile.getParentFile();
                throw error;
            }
        }
        System.clearProperty("mule.apikit.parser");
    }

    private String relativePath(File goldenFile) {
        try {
            File base = new File(((Object)((Object)this)).getClass().getClassLoader().getResource("").toURI());
            return base.toURI().relativize(goldenFile.toURI()).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<Arguments> getData() throws IOException, URISyntaxException {
        return MetadataTestCase.scanApps().stream().flatMap(app -> {
            try {
                return Stream.of(Arguments.of((Object[])new Object[]{"RAML", app}), Arguments.of((Object[])new Object[]{"AMF", app}));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private boolean isInvalidFileLocation(File app) {
        return app.getPath().contains("invalid-raml-file-location");
    }
}

