/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mule.module.apikit.metadata.internal.MetadataBuilderImpl;
import org.mule.module.apikit.metadata.internal.model.MetadataModel;
import org.mule.runtime.apikit.metadata.api.Metadata;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;
import org.mule.runtime.ast.api.ArtifactAst;

public class MetadataBuilderImplTest {
    private MetadataBuilderImpl metadataBuilder;
    @Mock
    private ResourceLoader mockResourceLoader;
    @Mock
    private ArtifactAst mockApplicationModel;
    @Mock
    private Notifier mockNotifier;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.metadataBuilder = new MetadataBuilderImpl();
    }

    @Test
    public void testWithResourceLoader() {
        MetadataBuilderImpl result = this.metadataBuilder.withResourceLoader(this.mockResourceLoader);
        Assertions.assertSame((Object)this.metadataBuilder, (Object)result);
    }

    @Test
    public void testWithApplicationModel() {
        MetadataBuilderImpl result = this.metadataBuilder.withApplicationModel(this.mockApplicationModel);
        Assertions.assertSame((Object)this.metadataBuilder, (Object)result);
    }

    @Test
    public void testWithNotifier() {
        MetadataBuilderImpl result = this.metadataBuilder.withNotifier(this.mockNotifier);
        Assertions.assertSame((Object)this.metadataBuilder, (Object)result);
    }

    @Test
    public void testBuild() {
        this.metadataBuilder.withResourceLoader(this.mockResourceLoader).withApplicationModel(this.mockApplicationModel).withNotifier(this.mockNotifier);
        Metadata result = this.metadataBuilder.build();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)(result instanceof MetadataModel));
    }

    @Test
    public void testBuildWithoutSettings() {
        Assertions.assertThrows(NullPointerException.class, () -> this.metadataBuilder.build());
    }

    @Test
    public void testMuleApikitParserConstant() {
        Assertions.assertEquals((Object)"mule.apikit.parser", (Object)"mule.apikit.parser");
    }
}

