/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.module.apikit.metadata.internal.MetadataServiceImpl;
import org.mule.module.apikit.metadata.internal.MetadataServiceProvider;
import org.mule.runtime.api.service.ServiceDefinition;

public class MetadataServiceProviderTest {
    @Test
    public void testGetServiceDefinition() {
        MetadataServiceProvider provider = new MetadataServiceProvider();
        ServiceDefinition serviceDefinition = provider.getServiceDefinition();
        Assertions.assertNotNull((Object)"Service definition should not be null", (String)serviceDefinition.toString());
        Assertions.assertInstanceOf(MetadataServiceImpl.class, (Object)serviceDefinition.getService(), (String)"Service instance should be of type MetadataServiceImpl");
    }

    @Test
    public void testServiceDefinitionConsistency() {
        MetadataServiceProvider provider = new MetadataServiceProvider();
        ServiceDefinition definition1 = provider.getServiceDefinition();
        ServiceDefinition definition2 = provider.getServiceDefinition();
        Assertions.assertNotNull((Object)"First service definition should not be null", (String)definition1.toString());
        Assertions.assertNotNull((Object)"Second service definition should not be null", (String)definition2.toString());
        Assertions.assertEquals(definition1.getService().getClass(), definition2.getService().getClass(), (String)"Service instances should be of the same type across calls");
    }

    @Test
    public void testServiceInstanceUniqueness() {
        MetadataServiceProvider provider = new MetadataServiceProvider();
        ServiceDefinition definition1 = provider.getServiceDefinition();
        ServiceDefinition definition2 = provider.getServiceDefinition();
        Assertions.assertNotSame((Object)definition1.getService(), (Object)definition2.getService(), (String)"Service instances should be unique for each call");
    }
}

