/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.amf;

import amf.apicontract.client.platform.APIConfiguration;
import amf.core.client.platform.model.domain.Shape;
import amf.shapes.client.platform.model.domain.ArrayShape;
import amf.shapes.client.platform.model.domain.FileShape;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.module.apikit.metadata.internal.amf.MetadataFactory;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={APIConfiguration.class})
class MetadataFactoryTest {
    MetadataFactoryTest() {
    }

    @Test
    void testFromJSONSchemaWithEmptyShape() {
        Shape emptyShape = (Shape)Mockito.mock(Shape.class);
        MetadataType result = MetadataFactory.fromJSONSchema((Shape)emptyShape, (String)"");
        Assert.assertTrue((boolean)(result instanceof AnyType));
    }

    @Test
    void testDefaultMetadataWithFileShape() {
        FileShape fileShape = (FileShape)Mockito.mock(FileShape.class);
        MetadataType result = MetadataFactory.defaultMetadata((Shape)fileShape);
        Assert.assertTrue((boolean)(result instanceof StringType));
    }

    @Test
    void testFromJSONSchemawithFileShape() {
        FileShape fileShape = new FileShape();
        MetadataType result = MetadataFactory.fromJSONSchema((Shape)fileShape, (String)"example");
        Assert.assertTrue((boolean)(result instanceof StringType));
    }

    @Test
    void testFromXSDSchemawithFileShape() {
        FileShape fileShape = new FileShape();
        MetadataType result = MetadataFactory.fromXSDSchema((Shape)fileShape, (String)"example");
        Assert.assertTrue((boolean)(result instanceof StringType));
    }

    @Test
    void testFromXSDSchemawithFileShapeandExample() {
        String xmlSchema = "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">  <xs:element name=\"root\">    <xs:complexType>      <xs:sequence>        <xs:element name=\"child\" type=\"xs:string\"/>      </xs:sequence>    </xs:complexType>  </xs:element></xs:schema>";
        FileShape fileShape = new FileShape();
        MetadataType result = MetadataFactory.fromXSDSchema((Shape)fileShape, (String)xmlSchema);
        Assert.assertNotNull((Object)result);
    }

    @Test
    void testDefaultMetadataWithArrayShape() {
        ArrayShape arrayShape = (ArrayShape)Mockito.mock(ArrayShape.class);
        MetadataType result = MetadataFactory.defaultMetadata((Shape)arrayShape);
        Assert.assertTrue((boolean)(result instanceof ArrayType));
        ArrayType arrayType = (ArrayType)result;
        Assert.assertTrue((boolean)(arrayType.getType() instanceof StringType));
    }

    @Test
    void testStringMetadata() {
        MetadataType result = MetadataFactory.stringMetadata();
        Assert.assertTrue((boolean)(result instanceof StringType));
    }

    @Test
    void testArrayStringMetadata() {
        MetadataType result = MetadataFactory.arrayStringMetadata();
        Assert.assertTrue((boolean)(result instanceof ArrayType));
        ArrayType arrayType = (ArrayType)result;
        Assert.assertTrue((boolean)(arrayType.getType() instanceof StringType));
    }

    @Test
    void testBooleanMetadata() {
        MetadataType result = MetadataFactory.booleanMetadada();
        Assert.assertTrue((boolean)(result instanceof BooleanType));
    }

    @Test
    void testNumberMetadata() {
        MetadataType result = MetadataFactory.numberMetadata();
        Assert.assertTrue((boolean)(result instanceof NumberType));
    }

    @Test
    void testIntegerMetadata() {
        MetadataType result = MetadataFactory.integerMetadata();
        Assert.assertTrue((boolean)(result instanceof NumberType));
    }

    @Test
    void testDateTimeMetadata() {
        MetadataType result = MetadataFactory.dateTimeMetadata();
        Assert.assertTrue((boolean)(result instanceof DateTimeType));
    }

    @Test
    void testObjectMetadata() {
        MetadataType result = MetadataFactory.objectMetadata();
        Assert.assertTrue((boolean)(result instanceof ObjectType));
    }

    @Test
    void testBinaryMetadata() {
        MetadataType result = MetadataFactory.binaryMetadata();
        Assert.assertTrue((boolean)(result instanceof BinaryType));
    }
}

