/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.raml;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.Resource;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.module.apikit.metadata.internal.raml.FlowMetadata;
import org.mule.module.apikit.metadata.internal.raml.RamlApiWrapper;
import org.mule.runtime.apikit.metadata.api.Notifier;

public class RamlApiWrapperTest {
    @Mock
    private ApiSpecification mockApiSpecification;
    @Mock
    private Notifier mockNotifier;
    @Mock
    private Resource mockResource;
    @Mock
    private Action mockAction;
    private RamlApiWrapper ramlApiWrapper;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        HashMap<String, Resource> resources = new HashMap<String, Resource>();
        resources.put("/test", this.mockResource);
        Mockito.when((Object)this.mockApiSpecification.getResources()).thenReturn(resources);
        Mockito.when((Object)this.mockApiSpecification.getVersion()).thenReturn((Object)"1.0");
        Mockito.when((Object)this.mockApiSpecification.getConsolidatedSchemas()).thenReturn(new HashMap());
        Mockito.when((Object)this.mockApiSpecification.getBaseUriParameters()).thenReturn(new HashMap());
        Mockito.when((Object)this.mockResource.getResolvedUri("1.0")).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockResource.getResources()).thenReturn(new HashMap());
        this.ramlApiWrapper = new RamlApiWrapper(this.mockApiSpecification, this.mockNotifier);
    }

    @Test
    public void testCollectResources() {
        ((Resource)Mockito.verify((Object)this.mockResource)).getResolvedUri("1.0");
        ((Resource)Mockito.verify((Object)this.mockResource)).getResources();
    }

    @Test
    public void testGetMetadataSourceWithExistingResource() {
        Mockito.when((Object)this.mockResource.getAction("GET")).thenReturn((Object)this.mockAction);
        ApiCoordinate coordinate = new ApiCoordinate("/test", "GET", "/test", null, null);
        Optional result = this.ramlApiWrapper.getMetadataSource(coordinate, "httpStatus", "outboundHeaders");
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertTrue((boolean)(result.get() instanceof FlowMetadata));
    }

    @Test
    public void testGetMetadataSourceWithNonExistingResource() {
        ApiCoordinate coordinate = new ApiCoordinate("/nonexistent", "GET", null, null, null);
        Optional result = this.ramlApiWrapper.getMetadataSource(coordinate, "httpStatus", "outboundHeaders");
        Assertions.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetMetadataSourceWithNonExistingMethod() {
        Mockito.when((Object)this.mockResource.getAction("POST")).thenReturn(null);
        ApiCoordinate coordinate = new ApiCoordinate("/test", "POST", null, null, null);
        Optional result = this.ramlApiWrapper.getMetadataSource(coordinate, "httpStatus", "outboundHeaders");
        Assertions.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetConsolidatedSchemas() {
        HashMap expectedSchemas = new HashMap();
        Mockito.when((Object)this.mockApiSpecification.getConsolidatedSchemas()).thenReturn(expectedSchemas);
        this.ramlApiWrapper = new RamlApiWrapper(this.mockApiSpecification, this.mockNotifier);
        Map result = this.ramlApiWrapper.getConsolidatedSchemas();
        Assertions.assertEquals(expectedSchemas, (Object)result);
    }
}

