/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestAuthentication;
import org.mule.runtime.http.api.client.async.ResponseHandler;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;

public class TestHttpClient
extends ExternalResource
implements HttpClient {
    private final HttpService httpService;
    private TlsContextFactory tlsContextFactory;
    private HttpClient httpClient;

    private TestHttpClient() {
        this((HttpService)new HttpServiceImplementation((SchedulerService)new SimpleUnitTestSupportSchedulerService()));
    }

    private TestHttpClient(HttpService httpService) {
        Preconditions.checkArgument((httpService != null ? 1 : 0) != 0, (String)"httpService cannot be null");
        this.httpService = httpService;
    }

    protected void before() throws Throwable {
        HttpClientConfiguration.Builder builder = new HttpClientConfiguration.Builder();
        if (this.tlsContextFactory != null) {
            builder.setTlsContextFactory(this.tlsContextFactory);
        }
        HttpClientConfiguration configuration = builder.setName(((Object)((Object)this)).getClass().getSimpleName()).build();
        this.httpClient = this.httpService.getClientFactory().create(configuration);
        this.httpClient.start();
    }

    protected void after() {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }

    public void start() {
        this.httpClient.start();
    }

    public void stop() {
        this.httpClient.stop();
    }

    public HttpResponse send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication) throws IOException, TimeoutException {
        return this.httpClient.send(request, responseTimeout, followRedirects, authentication);
    }

    public void send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication, ResponseHandler handler) {
        this.httpClient.send(request, responseTimeout, followRedirects, authentication, handler);
    }

    public static class Builder {
        private final HttpService service;
        private TlsContextFactory tlsContextFactory;

        public Builder() {
            this.service = null;
        }

        public Builder(HttpService httpService) {
            this.service = httpService;
        }

        public Builder tlsContextFactory(TlsContextFactory tlsContextFactory) {
            this.tlsContextFactory = tlsContextFactory;
            return this;
        }

        public Builder tlsContextFactory(Supplier<TlsContextFactory> tlsContextFactorySupplier) {
            TlsContextFactory tlsContextFactoryLocal = tlsContextFactorySupplier.get();
            try {
                LifecycleUtils.initialiseIfNeeded((Object)tlsContextFactoryLocal);
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            this.tlsContextFactory = tlsContextFactoryLocal;
            return this;
        }

        public TestHttpClient build() {
            TestHttpClient httpClient = this.service == null ? new TestHttpClient() : new TestHttpClient(this.service);
            httpClient.tlsContextFactory = this.tlsContextFactory;
            return httpClient;
        }
    }
}

