/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.tcp.TcpServerSocketProperties;
import org.mule.service.http.impl.service.server.DefaultServerAddress;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.ServerIdentifier;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyServerManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public abstract class AbstractGrizzlyServerManagerTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public DynamicPort listenerPort = new DynamicPort("listener.port");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ExecutorService selectorPool;
    private ExecutorService workerPool;
    private ExecutorService idleTimeoutExecutorService;
    protected GrizzlyServerManager serverManager;

    @Before
    public void before() {
        this.selectorPool = Executors.newCachedThreadPool();
        this.workerPool = Executors.newCachedThreadPool();
        this.idleTimeoutExecutorService = Executors.newCachedThreadPool();
        HttpListenerRegistry registry = new HttpListenerRegistry();
        DefaultTcpServerSocketProperties socketProperties = new DefaultTcpServerSocketProperties();
        this.serverManager = new GrizzlyServerManager(this.selectorPool, this.workerPool, this.idleTimeoutExecutorService, registry, (TcpServerSocketProperties)socketProperties);
    }

    @After
    public void after() {
        this.serverManager.dispose();
        this.selectorPool.shutdown();
        this.workerPool.shutdown();
        this.idleTimeoutExecutorService.shutdown();
    }

    protected abstract HttpServer getServer(ServerAddress var1, ServerIdentifier var2) throws IOException;

    @Test
    public void managerDisposeClosesServerOpenConnections() throws IOException {
        GrizzlyServerManager serverManager = new GrizzlyServerManager(this.selectorPool, this.workerPool, this.idleTimeoutExecutorService, new HttpListenerRegistry(), (TcpServerSocketProperties)new DefaultTcpServerSocketProperties());
        HttpServer server = serverManager.createServerFor((ServerAddress)new DefaultServerAddress("0.0.0.0", this.listenerPort.getNumber()), () -> muleContext.getSchedulerService().ioScheduler(), true, (int)TimeUnit.SECONDS.toMillis(60L), new ServerIdentifier("context", "name"));
        ResponseStatusCallback responseStatusCallback = (ResponseStatusCallback)Mockito.mock(ResponseStatusCallback.class);
        server.addRequestHandler("/path", (requestContext, responseCallback) -> responseCallback.responseReady(HttpResponse.builder().setStatusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).build(), responseStatusCallback));
        server.start();
        try (Socket clientSocket = new Socket("localhost", this.listenerPort.getNumber());){
            String t;
            PrintWriter writer = new PrintWriter(clientSocket.getOutputStream());
            writer.println("GET /path HTTP/1.1");
            writer.println("Host: localhost");
            writer.println("");
            writer.flush();
            BufferedReader br = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
            while ((t = br.readLine()) != null && !t.equals("0")) {
            }
            ((ResponseStatusCallback)Mockito.verify((Object)responseStatusCallback, (VerificationMode)Mockito.timeout((long)1000L))).responseSendSuccessfully();
            server.stop();
            serverManager.dispose();
            while ((t = br.readLine()) != null) {
            }
            br.close();
        }
    }

    @Test
    public void canFindServerInSameContext() throws Exception {
        ServerIdentifier identifier = new ServerIdentifier("context", "name");
        HttpServer createdServer = this.serverManager.createServerFor((ServerAddress)new DefaultServerAddress("0.0.0.0", this.listenerPort.getNumber()), () -> muleContext.getSchedulerService().ioScheduler(), true, (int)TimeUnit.SECONDS.toMillis(60L), identifier);
        HttpServer foundServer = this.serverManager.lookupServer(new ServerIdentifier("context", "name"));
        Assert.assertThat((Object)createdServer.getServerAddress(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)foundServer.getServerAddress())));
        createdServer.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cannotFindServerInDifferentContext() throws Exception {
        String name = "name";
        ServerIdentifier identifier = new ServerIdentifier("context", name);
        HttpServer server = this.serverManager.createServerFor((ServerAddress)new DefaultServerAddress("0.0.0.0", this.listenerPort.getNumber()), () -> muleContext.getSchedulerService().ioScheduler(), true, (int)TimeUnit.SECONDS.toMillis(60L), identifier);
        try {
            this.expectedException.expect(ServerNotFoundException.class);
            this.expectedException.expectMessage(Matchers.is((Object)"Server 'name' could not be found."));
            this.serverManager.lookupServer(new ServerIdentifier("otherContext", name));
        }
        finally {
            server.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void serverWithSameNameInSameContextOverlaps() throws Exception {
        ServerIdentifier identifier = new ServerIdentifier("context", "name");
        DefaultServerAddress serverAddress = new DefaultServerAddress("someHost", this.listenerPort.getNumber());
        HttpServer server = this.getServer((ServerAddress)serverAddress, identifier);
        DefaultServerAddress otherServerAddress = new DefaultServerAddress("otherHost", this.listenerPort.getNumber());
        try {
            Assert.assertThat((Object)this.serverManager.containsServerFor((ServerAddress)otherServerAddress, identifier), (Matcher)Matchers.is((Object)true));
        }
        finally {
            server.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void serverWithSameNameInDifferentContextDoesNotOverlaps() throws Exception {
        String name = "name";
        ServerIdentifier identifier = new ServerIdentifier("context", name);
        DefaultServerAddress serverAddress = new DefaultServerAddress("someHost", this.listenerPort.getNumber());
        HttpServer server = this.getServer((ServerAddress)serverAddress, identifier);
        DefaultServerAddress otherServerAddress = new DefaultServerAddress("otherHost", this.listenerPort.getNumber());
        ServerIdentifier otherIdentifier = new ServerIdentifier("otherContext", name);
        try {
            Assert.assertThat((Object)this.serverManager.containsServerFor((ServerAddress)otherServerAddress, otherIdentifier), (Matcher)Matchers.is((Object)false));
        }
        finally {
            server.dispose();
        }
    }

    @Test
    public void serverIsRemovedAfterDispose() throws Exception {
        ServerIdentifier identifier = new ServerIdentifier("context", "name");
        DefaultServerAddress serverAddress = new DefaultServerAddress("0.0.0.0", this.listenerPort.getNumber());
        HttpServer server = this.getServer((ServerAddress)serverAddress, identifier);
        server.start();
        server.stop();
        server.dispose();
        this.expectedException.expect(ServerNotFoundException.class);
        this.expectedException.expectMessage(Matchers.is((Object)"Server 'name' could not be found."));
        this.serverManager.lookupServer(identifier);
    }

    @Test
    public void onlyOwnerCanStartServer() throws Exception {
        ServerIdentifier identifier = new ServerIdentifier("context", "name");
        DefaultServerAddress serverAddress = new DefaultServerAddress("0.0.0.0", this.listenerPort.getNumber());
        HttpServer owner = this.getServer((ServerAddress)serverAddress, identifier);
        HttpServer reference = this.serverManager.lookupServer(identifier);
        Assert.assertThat((Object)owner.isStopped(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)reference.isStopped(), (Matcher)Matchers.is((Object)true));
        reference.start();
        Assert.assertThat((Object)owner.isStopped(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)reference.isStopped(), (Matcher)Matchers.is((Object)true));
        owner.start();
        Assert.assertThat((Object)owner.isStopped(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)reference.isStopped(), (Matcher)Matchers.is((Object)false));
        owner.stop();
        owner.dispose();
    }

    @Test
    public void onlyOwnerCanStopServer() throws Exception {
        ServerIdentifier identifier = new ServerIdentifier("context", "name");
        DefaultServerAddress serverAddress = new DefaultServerAddress("0.0.0.0", this.listenerPort.getNumber());
        HttpServer owner = this.getServer((ServerAddress)serverAddress, identifier);
        HttpServer reference = this.serverManager.lookupServer(identifier);
        owner.start();
        Assert.assertThat((Object)owner.isStopped(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)reference.isStopped(), (Matcher)Matchers.is((Object)false));
        reference.stop();
        Assert.assertThat((Object)owner.isStopped(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)reference.isStopped(), (Matcher)Matchers.is((Object)false));
        owner.stop();
        Assert.assertThat((Object)owner.isStopped(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)reference.isStopped(), (Matcher)Matchers.is((Object)true));
        owner.dispose();
    }

    @Test
    public void onlyOwnerCanDisposeServer() throws Exception {
        ServerIdentifier identifier = new ServerIdentifier("context", "name");
        DefaultServerAddress serverAddress = new DefaultServerAddress("0.0.0.0", this.listenerPort.getNumber());
        HttpServer owner = this.getServer((ServerAddress)serverAddress, identifier);
        HttpServer reference = this.serverManager.lookupServer(identifier);
        Assert.assertThat((Object)this.serverManager.containsServerFor((ServerAddress)serverAddress, identifier), (Matcher)Matchers.is((Object)true));
        owner.start();
        owner.stop();
        reference.dispose();
        Assert.assertThat((Object)this.serverManager.containsServerFor((ServerAddress)serverAddress, identifier), (Matcher)Matchers.is((Object)true));
        owner.dispose();
        Assert.assertThat((Object)this.serverManager.containsServerFor((ServerAddress)serverAddress, identifier), (Matcher)Matchers.is((Object)false));
    }

    private class DefaultTcpServerSocketProperties
    implements TcpServerSocketProperties {
        private DefaultTcpServerSocketProperties() {
        }

        public Integer getSendBufferSize() {
            return null;
        }

        public Integer getReceiveBufferSize() {
            return null;
        }

        public Integer getClientTimeout() {
            return null;
        }

        public Boolean getSendTcpNoDelay() {
            return true;
        }

        public Integer getLinger() {
            return null;
        }

        public Boolean getKeepAlive() {
            return false;
        }

        public Boolean getReuseAddress() {
            return true;
        }

        public Integer getReceiveBacklog() {
            return 50;
        }

        public Integer getServerTimeout() {
            return null;
        }
    }
}

