/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.service.http.impl.service.server.grizzly.DefaultMethodRequestMatcher;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

@SmallTest
@Features(value={"HTTP Service"})
@Stories(value={"Listeners"})
public class DefaultMethodRequestMatcherTestCase
extends AbstractMuleTestCase {
    private HttpRequestBuilder requestBuilder = HttpRequest.builder().setUri("uri");

    @Test(expected=IllegalArgumentException.class)
    public void doNotAcceptsEmptyString() {
        new DefaultMethodRequestMatcher(new String[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void doNotAcceptsEmptyMethod() {
        new DefaultMethodRequestMatcher(new HttpConstants.Method[0]);
    }

    @Test
    public void onlyAcceptsOneMethod() {
        DefaultMethodRequestMatcher matcher = new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.GET});
        Assert.assertThat((Object)matcher.matches(this.requestBuilder.setMethod(HttpConstants.Method.GET).build()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)matcher.matches(this.requestBuilder.setMethod(HttpConstants.Method.POST).build()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void acceptSeveralMethods() {
        DefaultMethodRequestMatcher matcher = new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.GET, HttpConstants.Method.POST, HttpConstants.Method.PATCH});
        Assert.assertThat((Object)matcher.matches(this.requestBuilder.setMethod(HttpConstants.Method.GET).build()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)matcher.matches(this.requestBuilder.setMethod(HttpConstants.Method.POST).build()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)matcher.matches(this.requestBuilder.setMethod(HttpConstants.Method.PATCH).build()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)matcher.matches(this.requestBuilder.setMethod(HttpConstants.Method.OPTIONS).build()), (Matcher)Is.is((Object)false));
    }
}

