/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.service.http.impl.service.server.DefaultServerAddress;
import org.mule.service.http.impl.service.server.ServerIdentifier;
import org.mule.service.http.impl.service.server.grizzly.AbstractGrizzlyServerManagerTestCase;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

@Features(value={"HTTP Service"})
@Stories(value={"Server Management"})
public class HttpsGrizzlyServerManagerTestCase
extends AbstractGrizzlyServerManagerTestCase {
    private final TlsContextFactory tlsContextFactory = TlsContextFactory.builder().buildDefault();

    @Override
    protected HttpServer getServer(ServerAddress address, ServerIdentifier id) throws IOException {
        return this.serverManager.createSslServerFor(this.tlsContextFactory, () -> muleContext.getSchedulerService().ioScheduler(), address, true, (int)TimeUnit.SECONDS.toMillis(60L), id);
    }

    @Test
    public void sslServerIsHttps() throws Exception {
        HttpServer createdServer = this.getServer((ServerAddress)new DefaultServerAddress("0.0.0.0", this.listenerPort.getNumber()), new ServerIdentifier("context", "name"));
        try {
            Assert.assertThat((Object)createdServer.getProtocol(), (Matcher)Matchers.is((Object)HttpConstants.Protocol.HTTPS));
        }
        finally {
            createdServer.dispose();
        }
    }
}

