/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.connectionpool;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectorHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.connectionpool.Chain;
import org.glassfish.grizzly.connectionpool.ConnectionInfo;
import org.glassfish.grizzly.connectionpool.Endpoint;
import org.glassfish.grizzly.connectionpool.EndpointKey;
import org.glassfish.grizzly.connectionpool.Link;
import org.glassfish.grizzly.connectionpool.SingleEndpointPool;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.Futures;

public class MultiEndpointPool<E> {
    private static final Logger LOGGER = Grizzly.logger(MultiEndpointPool.class);
    protected final Map<Endpoint<E>, SingleEndpointPool<E>> endpointToPoolMap = DataStructures.getConcurrentMap();
    private final Map<Connection, ConnectionInfo<E>> connectionToSubPoolMap = DataStructures.getConcurrentMap();
    protected final Object poolSync = new Object();
    private final Object countersSync = new Object();
    private boolean isClosed;
    private int poolSize;
    private int totalPendingConnections;
    private final Chain<EndpointPoolImpl> maxPoolSizeHitsChain = new Chain();
    private final DelayedExecutor delayedExecutor;
    private final ExecutorService ownDelayedExecutorThreadPool;
    private final DelayedExecutor ownDelayedExecutor;
    private DelayedExecutor.DelayQueue<SingleEndpointPool.ConnectTimeoutTask> connectTimeoutQueue;
    private DelayedExecutor.DelayQueue<SingleEndpointPool.ReconnectTask> reconnectQueue;
    private DelayedExecutor.DelayQueue<SingleEndpointPool.KeepAliveCleanerTask> keepAliveCleanerQueue;
    private DelayedExecutor.DelayQueue<Link<SingleEndpointPool.AsyncPoll>> asyncPollTimeoutQueue;
    private DelayedExecutor.DelayQueue<ConnectionInfo> connectionTTLQueue;
    private final ConnectorHandler<E> defaultConnectorHandler;
    private final EndpointPoolCustomizer<E> endpointPoolCustomizer;
    private final int maxConnectionsPerEndpoint;
    private final int maxConnectionsTotal;
    private final long connectTimeoutMillis;
    private final long reconnectDelayMillis;
    private final long keepAliveTimeoutMillis;
    private final long keepAliveCheckIntervalMillis;
    private final long asyncPollTimeoutMillis;
    private final long connectionTTLMillis;
    private final int maxReconnectAttempts;
    private final boolean failFastWhenMaxSizeReached;

    public static <T> Builder<T> builder(Class<T> endpointType) {
        return new Builder();
    }

    protected MultiEndpointPool(ConnectorHandler<E> defaultConnectorHandler, int maxConnectionsPerEndpoint, int maxConnectionsTotal, DelayedExecutor delayedExecutor, long connectTimeoutMillis, long keepAliveTimeoutMillis, long keepAliveCheckIntervalMillis, long reconnectDelayMillis, int maxReconnectAttempts, long asyncPollTimeoutMillis, long connectionTTLMillis, boolean failFastWhenMaxSizeReached, EndpointPoolCustomizer<E> endpointPoolCustomizer) {
        this.defaultConnectorHandler = defaultConnectorHandler;
        this.maxConnectionsPerEndpoint = maxConnectionsPerEndpoint;
        this.maxConnectionsTotal = maxConnectionsTotal;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.reconnectDelayMillis = reconnectDelayMillis;
        this.keepAliveTimeoutMillis = keepAliveTimeoutMillis;
        this.keepAliveCheckIntervalMillis = keepAliveCheckIntervalMillis;
        this.maxReconnectAttempts = maxReconnectAttempts;
        this.asyncPollTimeoutMillis = asyncPollTimeoutMillis;
        this.connectionTTLMillis = connectionTTLMillis;
        this.failFastWhenMaxSizeReached = failFastWhenMaxSizeReached;
        this.endpointPoolCustomizer = endpointPoolCustomizer;
        if (delayedExecutor == null) {
            ThreadPoolConfig tpc = ThreadPoolConfig.defaultConfig().setPoolName("connection-pool-delays-thread-pool").setCorePoolSize(1).setMaxPoolSize(1);
            this.ownDelayedExecutorThreadPool = GrizzlyExecutorService.createInstance((ThreadPoolConfig)tpc);
            this.ownDelayedExecutor = new DelayedExecutor(this.ownDelayedExecutorThreadPool);
            this.ownDelayedExecutor.start();
            this.delayedExecutor = this.ownDelayedExecutor;
        } else {
            this.ownDelayedExecutorThreadPool = null;
            this.ownDelayedExecutor = null;
            this.delayedExecutor = delayedExecutor;
        }
        this.checkConnectTimeoutQueue(connectTimeoutMillis);
        this.checkReconnectQueue(reconnectDelayMillis);
        this.checkKeepAliveCleanerQueue(keepAliveTimeoutMillis);
        this.checkAsyncPollTimeoutQueue(asyncPollTimeoutMillis);
        this.checkConnectionTTLQueue(connectionTTLMillis);
    }

    protected MultiEndpointPool(int maxConnectionsPerEndpoint, int maxConnectionsTotal, DelayedExecutor delayedExecutor, long connectTimeoutMillis, long keepAliveTimeoutMillis, long keepAliveCheckIntervalMillis, long reconnectDelayMillis, int maxReconnectAttempts, long asyncPollTimeoutMillis, long connectionTTLMillis, boolean failFastWhenMaxSizeReached, EndpointPoolCustomizer<E> endpointPoolCustomizer) {
        this(null, maxConnectionsPerEndpoint, maxConnectionsTotal, delayedExecutor, connectTimeoutMillis, keepAliveTimeoutMillis, keepAliveCheckIntervalMillis, reconnectDelayMillis, maxReconnectAttempts, asyncPollTimeoutMillis, connectionTTLMillis, failFastWhenMaxSizeReached, endpointPoolCustomizer);
    }

    public int getMaxConnectionsTotal() {
        return this.maxConnectionsTotal;
    }

    public int getMaxConnectionsPerEndpoint() {
        return this.maxConnectionsPerEndpoint;
    }

    public long getConnectTimeout(TimeUnit timeUnit) {
        return this.connectTimeoutMillis <= 0L ? this.connectTimeoutMillis : timeUnit.convert(this.connectTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public long getReconnectDelay(TimeUnit timeUnit) {
        return this.reconnectDelayMillis <= 0L ? this.reconnectDelayMillis : timeUnit.convert(this.reconnectDelayMillis, TimeUnit.MILLISECONDS);
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public long getKeepAliveTimeout(TimeUnit timeUnit) {
        return this.keepAliveTimeoutMillis <= 0L ? this.keepAliveTimeoutMillis : timeUnit.convert(this.keepAliveTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public long getKeepAliveCheckInterval(TimeUnit timeUnit) {
        return this.keepAliveCheckIntervalMillis <= 0L ? this.keepAliveCheckIntervalMillis : timeUnit.convert(this.keepAliveCheckIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public long getAsyncPollTimeout(TimeUnit timeUnit) {
        return this.asyncPollTimeoutMillis <= 0L ? this.asyncPollTimeoutMillis : timeUnit.convert(this.asyncPollTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public long getConnectionTTL(TimeUnit timeUnit) {
        return this.connectionTTLMillis <= 0L ? this.connectionTTLMillis : timeUnit.convert(this.connectionTTLMillis, TimeUnit.MILLISECONDS);
    }

    public boolean isFailFastWhenMaxSizeReached() {
        return this.failFastWhenMaxSizeReached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.countersSync;
        synchronized (object) {
            return this.poolSize + this.totalPendingConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOpenConnectionsCount() {
        Object object = this.countersSync;
        synchronized (object) {
            return this.poolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMaxCapacityReached() {
        Object object = this.countersSync;
        synchronized (object) {
            return this.maxConnectionsTotal != -1 && this.poolSize + this.totalPendingConnections >= this.maxConnectionsTotal;
        }
    }

    public boolean isRegistered(Connection connection) {
        return this.connectionToSubPoolMap.get(connection) != null;
    }

    public boolean isBusy(Connection connection) {
        ConnectionInfo<E> info = this.connectionToSubPoolMap.get(connection);
        return info != null && info.endpointPool.isBusy0(info);
    }

    public ConnectionInfo<E> getConnectionInfo(Connection connection) {
        return this.connectionToSubPoolMap.get(connection);
    }

    public GrizzlyFuture<Connection> take(Endpoint<E> endpoint) {
        try {
            SingleEndpointPool<E> sePool = this.obtainSingleEndpointPool(endpoint);
            return sePool.take();
        }
        catch (IOException e) {
            return Futures.createReadyFuture((Throwable)e);
        }
    }

    public void take(Endpoint<E> endpoint, CompletionHandler<Connection> completionHandler) {
        if (completionHandler == null) {
            throw new IllegalArgumentException("The completionHandler argument can not be null");
        }
        try {
            SingleEndpointPool<E> sePool = this.obtainSingleEndpointPool(endpoint);
            sePool.take(completionHandler);
        }
        catch (IOException e) {
            completionHandler.failed((Throwable)e);
        }
    }

    public Connection poll(Endpoint<E> endpoint) throws IOException {
        SingleEndpointPool<E> sePool = this.endpointToPoolMap.get(endpoint);
        return sePool != null ? sePool.poll() : null;
    }

    public boolean release(Connection connection) {
        ConnectionInfo<E> info = this.connectionToSubPoolMap.get(connection);
        if (info != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Returning {0} to endpoint pool {1}", new Object[]{connection, info.endpointPool});
            }
            return info.endpointPool.release0(info);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "No ConnectionInfo available for {0}.  Closing connection.", connection);
        }
        connection.closeSilently();
        return false;
    }

    public boolean attach(Endpoint<E> endpoint, Connection connection) throws IOException {
        SingleEndpointPool<E> sePool = this.obtainSingleEndpointPool(endpoint);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Associating foreign connection with pool {0} using endpoint key {1}.", new Object[]{sePool, endpoint});
        }
        return sePool.attach(connection);
    }

    public boolean detach(Connection connection) {
        ConnectionInfo<E> info = this.connectionToSubPoolMap.get(connection);
        if (info != null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Detaching {0} from endpoint pool {1}.", new Object[]{connection, info.endpointPool});
        }
        return info != null && info.endpointPool.detach(connection);
    }

    public void close(Endpoint<E> endpoint) {
        SingleEndpointPool<E> sePool = this.endpointToPoolMap.remove(endpoint);
        if (sePool != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Closing pool associated with endpoint key {0}", endpoint);
            }
            sePool.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.poolSync;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Shutting down. Closing all pools; shutting down executors as needed.");
            }
            this.isClosed = true;
            for (Map.Entry<Endpoint<E>, SingleEndpointPool<E>> entry : this.endpointToPoolMap.entrySet()) {
                try {
                    entry.getValue().close();
                }
                catch (Exception ignore) {}
            }
            this.endpointToPoolMap.clear();
            if (this.ownDelayedExecutor != null) {
                this.ownDelayedExecutor.destroy();
            }
            if (this.ownDelayedExecutorThreadPool != null) {
                this.ownDelayedExecutorThreadPool.shutdownNow();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "{" + "endpoint count=" + this.endpointToPoolMap.size() + "poolSize=" + this.poolSize + ", isClosed=" + this.isClosed + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleEndpointPool<E> obtainSingleEndpointPool(Endpoint<E> endpoint) throws IOException {
        SingleEndpointPool<E> sePool = this.endpointToPoolMap.get(endpoint);
        if (sePool == null) {
            Object object = this.poolSync;
            synchronized (object) {
                this.checkNotClosed();
                sePool = this.endpointToPoolMap.get(endpoint);
                if (sePool == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Creating new endpoint pool for key {0}", endpoint);
                    }
                    sePool = this.createSingleEndpointPool(endpoint);
                    this.endpointToPoolMap.put(endpoint, sePool);
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Returning existing pool {0} for key {1}", new Object[]{sePool, endpoint});
                }
            }
        }
        return sePool;
    }

    protected SingleEndpointPool<E> createSingleEndpointPool(Endpoint<E> endpoint) {
        if (this.endpointPoolCustomizer == null) {
            return new EndpointPoolImpl(endpoint);
        }
        EndpointPoolBuilder<E> builder = new EndpointPoolBuilder<E>(this, endpoint);
        this.endpointPoolCustomizer.customize(endpoint, builder);
        return builder.build();
    }

    protected void checkNotClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("The pool is closed");
        }
    }

    private EndpointPoolImpl getPrioritizedPool() {
        EndpointPoolImpl prioritizedPool;
        Link<EndpointPoolImpl> firstLink = this.maxPoolSizeHitsChain.pollFirst();
        if (firstLink != null) {
            prioritizedPool = firstLink.getValue();
            prioritizedPool.maxPoolSizeHits = 0;
        } else {
            prioritizedPool = null;
        }
        return prioritizedPool;
    }

    private Endpoint<E> checkWithDefaultConnectorHandler(Endpoint<E> endpoint) {
        EndpointKey epk;
        if (this.defaultConnectorHandler != null && endpoint instanceof EndpointKey && (epk = (EndpointKey)endpoint).getConnectorHandler() == null) {
            endpoint = new Endpoint<E>(){

                @Override
                public Object getId() {
                    return epk.getId();
                }

                @Override
                public GrizzlyFuture<Connection> connect() {
                    return (GrizzlyFuture)MultiEndpointPool.this.defaultConnectorHandler.connect(epk.getEndpoint(), epk.getLocalEndpoint());
                }
            };
        }
        return endpoint;
    }

    private void checkConnectTimeoutQueue(long connectTimeoutMillis) {
        if (connectTimeoutMillis >= 0L && this.connectTimeoutQueue == null) {
            this.connectTimeoutQueue = this.delayedExecutor.createDelayQueue((DelayedExecutor.Worker)new SingleEndpointPool.ConnectTimeoutWorker(), (DelayedExecutor.Resolver)new SingleEndpointPool.ConnectTimeoutTaskResolver());
        }
    }

    private void checkReconnectQueue(long reconnectDelayMillis) {
        if (reconnectDelayMillis >= 0L && this.reconnectQueue == null) {
            this.reconnectQueue = this.delayedExecutor.createDelayQueue((DelayedExecutor.Worker)new SingleEndpointPool.Reconnector(), (DelayedExecutor.Resolver)new SingleEndpointPool.ReconnectTaskResolver());
        }
    }

    private void checkKeepAliveCleanerQueue(long keepAliveTimeoutMillis) {
        if (keepAliveTimeoutMillis > 0L && this.keepAliveCleanerQueue == null) {
            this.keepAliveCleanerQueue = this.delayedExecutor.createDelayQueue((DelayedExecutor.Worker)new SingleEndpointPool.KeepAliveCleaner(), (DelayedExecutor.Resolver)new SingleEndpointPool.KeepAliveCleanerTaskResolver());
        }
    }

    private void checkAsyncPollTimeoutQueue(long asyncPollTimeoutMillis) {
        if (asyncPollTimeoutMillis >= 0L && this.asyncPollTimeoutQueue == null) {
            this.asyncPollTimeoutQueue = this.delayedExecutor.createDelayQueue((DelayedExecutor.Worker)new SingleEndpointPool.AsyncPollTimeoutWorker(), (DelayedExecutor.Resolver)new SingleEndpointPool.AsyncPollTimeoutTaskResolver());
        }
    }

    private void checkConnectionTTLQueue(long connectionTTLMillis) {
        if (connectionTTLMillis >= 0L && this.connectionTTLQueue == null) {
            this.connectionTTLQueue = this.delayedExecutor.createDelayQueue((DelayedExecutor.Worker)new SingleEndpointPool.ConnectionTTLWorker(), (DelayedExecutor.Resolver)new SingleEndpointPool.ConnectionTTLTaskResolver());
        }
    }

    public static class Builder<E> {
        private ConnectorHandler<E> defaultConnectorHandler;
        private int maxConnectionsPerEndpoint = 2;
        private int maxConnectionsTotal = 16;
        private DelayedExecutor delayedExecutor;
        private long connectTimeoutMillis = -1L;
        private long reconnectDelayMillis = -1L;
        private int maxReconnectAttempts = 5;
        private long asyncPollTimeoutMillis = -1L;
        private long connectionTTLMillis = -1L;
        private boolean failFastWhenMaxSizeReached;
        private long keepAliveTimeoutMillis = 30000L;
        private long keepAliveCheckIntervalMillis = 5000L;
        private EndpointPoolCustomizer<E> endpointPoolCustomizer;

        public Builder<E> connectorHandler(ConnectorHandler<E> defaultConnectorHandler) {
            this.defaultConnectorHandler = defaultConnectorHandler;
            return this;
        }

        public Builder<E> maxConnectionsPerEndpoint(int maxConnectionsPerEndpoint) {
            this.maxConnectionsPerEndpoint = maxConnectionsPerEndpoint;
            return this;
        }

        public Builder<E> maxConnectionsTotal(int maxConnectionsTotal) {
            this.maxConnectionsTotal = maxConnectionsTotal;
            return this;
        }

        public Builder<E> delayExecutor(DelayedExecutor delayedExecutor) {
            this.delayedExecutor = delayedExecutor;
            return this;
        }

        public Builder<E> connectTimeout(long connectTimeout, TimeUnit timeunit) {
            this.connectTimeoutMillis = connectTimeout > 0L ? TimeUnit.MILLISECONDS.convert(connectTimeout, timeunit) : connectTimeout;
            return this;
        }

        public Builder<E> reconnectDelay(long reconnectDelay, TimeUnit timeunit) {
            this.reconnectDelayMillis = reconnectDelay > 0L ? TimeUnit.MILLISECONDS.convert(reconnectDelay, timeunit) : reconnectDelay;
            return this;
        }

        public Builder<E> maxReconnectAttempts(int maxReconnectAttempts) {
            this.maxReconnectAttempts = maxReconnectAttempts;
            return this;
        }

        public Builder<E> asyncPollTimeout(long asyncPollTimeout, TimeUnit timeunit) {
            this.asyncPollTimeoutMillis = asyncPollTimeout > 0L ? TimeUnit.MILLISECONDS.convert(asyncPollTimeout, timeunit) : asyncPollTimeout;
            return this;
        }

        public Builder<E> connectionTTL(long connectionTTL, TimeUnit timeunit) {
            this.connectionTTLMillis = connectionTTL > 0L ? TimeUnit.MILLISECONDS.convert(connectionTTL, timeunit) : connectionTTL;
            return this;
        }

        public Builder<E> failFastWhenMaxSizeReached(boolean failFastWhenMaxSizeReached) {
            this.failFastWhenMaxSizeReached = failFastWhenMaxSizeReached;
            return this;
        }

        public Builder<E> keepAliveTimeout(long keepAliveTimeout, TimeUnit timeunit) {
            this.keepAliveTimeoutMillis = keepAliveTimeout > 0L ? TimeUnit.MILLISECONDS.convert(keepAliveTimeout, timeunit) : keepAliveTimeout;
            return this;
        }

        public Builder<E> keepAliveCheckInterval(long keepAliveCheckInterval, TimeUnit timeunit) {
            this.keepAliveCheckIntervalMillis = keepAliveCheckInterval > 0L ? TimeUnit.MILLISECONDS.convert(keepAliveCheckInterval, timeunit) : keepAliveCheckInterval;
            return this;
        }

        public Builder<E> endpointPoolCustomizer(EndpointPoolCustomizer<E> endpointPoolCustomizer) {
            this.endpointPoolCustomizer = endpointPoolCustomizer;
            return this;
        }

        public MultiEndpointPool<E> build() {
            if (this.keepAliveTimeoutMillis >= 0L && this.keepAliveCheckIntervalMillis < 0L) {
                throw new IllegalStateException("Keep-alive timeout is set, but keepAliveCheckInterval is invalid");
            }
            if (this.maxReconnectAttempts < 0) {
                throw new IllegalStateException("Max reconnect attempts must not be a negative value");
            }
            return new MultiEndpointPool<E>(this.defaultConnectorHandler, this.maxConnectionsPerEndpoint, this.maxConnectionsTotal, this.delayedExecutor, this.connectTimeoutMillis, this.keepAliveTimeoutMillis, this.keepAliveCheckIntervalMillis, this.reconnectDelayMillis, this.maxReconnectAttempts, this.asyncPollTimeoutMillis, this.connectionTTLMillis, this.failFastWhenMaxSizeReached, this.endpointPoolCustomizer);
        }
    }

    public static class EndpointPoolBuilder<E>
    extends SingleEndpointPool.Builder<E> {
        private final MultiEndpointPool<E> multiEndpointPool;

        EndpointPoolBuilder(MultiEndpointPool<E> multiEndpointPool, Endpoint<E> endpoint) {
            super(endpoint, null, null, null, 0, ((MultiEndpointPool)multiEndpointPool).maxConnectionsPerEndpoint, ((MultiEndpointPool)multiEndpointPool).delayedExecutor, ((MultiEndpointPool)multiEndpointPool).connectTimeoutMillis, ((MultiEndpointPool)multiEndpointPool).reconnectDelayMillis, ((MultiEndpointPool)multiEndpointPool).maxReconnectAttempts, ((MultiEndpointPool)multiEndpointPool).asyncPollTimeoutMillis, ((MultiEndpointPool)multiEndpointPool).connectionTTLMillis, ((MultiEndpointPool)multiEndpointPool).failFastWhenMaxSizeReached, ((MultiEndpointPool)multiEndpointPool).keepAliveTimeoutMillis, ((MultiEndpointPool)multiEndpointPool).keepAliveCheckIntervalMillis);
            this.multiEndpointPool = multiEndpointPool;
        }

        @Override
        public SingleEndpointPool<E> build0(Endpoint<E> e) {
            ((MultiEndpointPool)this.multiEndpointPool).checkConnectTimeoutQueue(this.connectTimeoutMillis);
            ((MultiEndpointPool)this.multiEndpointPool).checkReconnectQueue(this.reconnectDelayMillis);
            ((MultiEndpointPool)this.multiEndpointPool).checkKeepAliveCleanerQueue(this.keepAliveTimeoutMillis);
            ((MultiEndpointPool)this.multiEndpointPool).checkAsyncPollTimeoutQueue(this.asyncPollTimeoutMillis);
            ((MultiEndpointPool)this.multiEndpointPool).checkConnectionTTLQueue(this.connectionTTLMillis);
            MultiEndpointPool<E> multiEndpointPool = this.multiEndpointPool;
            multiEndpointPool.getClass();
            return multiEndpointPool.new EndpointPoolImpl(e, this.corePoolSize, this.maxPoolSize, (DelayedExecutor.DelayQueue<SingleEndpointPool.ConnectTimeoutTask>)((MultiEndpointPool)this.multiEndpointPool).connectTimeoutQueue, (DelayedExecutor.DelayQueue<SingleEndpointPool.ReconnectTask>)((MultiEndpointPool)this.multiEndpointPool).reconnectQueue, (DelayedExecutor.DelayQueue<SingleEndpointPool.KeepAliveCleanerTask>)((MultiEndpointPool)this.multiEndpointPool).keepAliveCleanerQueue, (DelayedExecutor.DelayQueue<Link<SingleEndpointPool.AsyncPoll>>)((MultiEndpointPool)this.multiEndpointPool).asyncPollTimeoutQueue, (DelayedExecutor.DelayQueue<ConnectionInfo>)((MultiEndpointPool)this.multiEndpointPool).connectionTTLQueue, this.connectTimeoutMillis, this.keepAliveTimeoutMillis, this.keepAliveCheckIntervalMillis, this.reconnectDelayMillis, this.maxReconnectAttempts, this.asyncPollTimeoutMillis, this.connectionTTLMillis, this.failFastWhenMaxSizeReached);
        }
    }

    private final class EndpointPoolImpl
    extends SingleEndpointPool<E> {
        private final Link<EndpointPoolImpl> maxPoolSizeHitsLink;
        private int maxPoolSizeHits;

        public EndpointPoolImpl(Endpoint<E> endpoint) {
            super(MultiEndpointPool.this.checkWithDefaultConnectorHandler(endpoint), 0, MultiEndpointPool.this.maxConnectionsPerEndpoint, (DelayedExecutor.DelayQueue<SingleEndpointPool.ConnectTimeoutTask>)MultiEndpointPool.this.connectTimeoutQueue, (DelayedExecutor.DelayQueue<SingleEndpointPool.ReconnectTask>)MultiEndpointPool.this.reconnectQueue, (DelayedExecutor.DelayQueue<SingleEndpointPool.KeepAliveCleanerTask>)MultiEndpointPool.this.keepAliveCleanerQueue, (DelayedExecutor.DelayQueue<Link<SingleEndpointPool.AsyncPoll>>)MultiEndpointPool.this.asyncPollTimeoutQueue, (DelayedExecutor.DelayQueue<ConnectionInfo>)MultiEndpointPool.this.connectionTTLQueue, MultiEndpointPool.this.connectTimeoutMillis, MultiEndpointPool.this.keepAliveTimeoutMillis, MultiEndpointPool.this.keepAliveCheckIntervalMillis, MultiEndpointPool.this.reconnectDelayMillis, MultiEndpointPool.this.maxReconnectAttempts, MultiEndpointPool.this.asyncPollTimeoutMillis, MultiEndpointPool.this.connectionTTLMillis, MultiEndpointPool.this.failFastWhenMaxSizeReached);
            this.maxPoolSizeHitsLink = new Link<EndpointPoolImpl>(this);
        }

        public EndpointPoolImpl(Endpoint<E> endpoint, int corePoolSize, int maxPoolSize, DelayedExecutor.DelayQueue<SingleEndpointPool.ConnectTimeoutTask> connectTimeoutQueue, DelayedExecutor.DelayQueue<SingleEndpointPool.ReconnectTask> reconnectQueue, DelayedExecutor.DelayQueue<SingleEndpointPool.KeepAliveCleanerTask> keepAliveCleanerQueue, DelayedExecutor.DelayQueue<Link<SingleEndpointPool.AsyncPoll>> asyncPollTimeoutQueue, DelayedExecutor.DelayQueue<ConnectionInfo> connectionTTLQueue, long connectTimeoutMillis, long keepAliveTimeoutMillis, long keepAliveCheckIntervalMillis, long reconnectDelayMillis, int maxReconnectAttempts, long asyncPollTimeoutMillis, long connectionTTLMillis, boolean failFastWhenMaxSizeReached) {
            super(MultiEndpointPool.this.checkWithDefaultConnectorHandler(endpoint), corePoolSize, maxPoolSize, connectTimeoutQueue, reconnectQueue, keepAliveCleanerQueue, asyncPollTimeoutQueue, connectionTTLQueue, connectTimeoutMillis, keepAliveTimeoutMillis, keepAliveCheckIntervalMillis, reconnectDelayMillis, maxReconnectAttempts, asyncPollTimeoutMillis, connectionTTLMillis, failFastWhenMaxSizeReached);
            this.maxPoolSizeHitsLink = new Link<EndpointPoolImpl>(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean checkBeforeOpeningConnection() {
            if (this.pendingConnections >= this.getWaitingListSize() || super.isMaxCapacityReached()) {
                return false;
            }
            Object object = MultiEndpointPool.this.countersSync;
            synchronized (object) {
                if (MultiEndpointPool.this.isMaxCapacityReached()) {
                    this.onMaxPoolSizeHit();
                    return false;
                }
                ++this.pendingConnections;
                MultiEndpointPool.this.totalPendingConnections++;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void onConnected(Connection connection) {
            super.onConnected(connection);
            Object object = MultiEndpointPool.this.countersSync;
            synchronized (object) {
                MultiEndpointPool.this.totalPendingConnections--;
            }
        }

        @Override
        public boolean isMaxCapacityReached() {
            return MultiEndpointPool.this.isMaxCapacityReached() || super.isMaxCapacityReached();
        }

        @Override
        boolean isOverflown() {
            return MultiEndpointPool.this.maxConnectionsTotal != -1 && MultiEndpointPool.this.poolSize >= MultiEndpointPool.this.maxConnectionsTotal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        ConnectionInfo<E> attach0(Connection connection) {
            ConnectionInfo info = super.attach0(connection);
            MultiEndpointPool.this.connectionToSubPoolMap.put(connection, info);
            Object object = MultiEndpointPool.this.countersSync;
            synchronized (object) {
                MultiEndpointPool.this.poolSize++;
            }
            return info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void onFailedConnection() {
            Object object = MultiEndpointPool.this.countersSync;
            synchronized (object) {
                MultiEndpointPool.this.totalPendingConnections--;
            }
            super.onFailedConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void onCloseConnection(ConnectionInfo<E> info) {
            EndpointPoolImpl prioritizedPool;
            Connection connection = info.connection;
            MultiEndpointPool.this.connectionToSubPoolMap.remove(connection);
            Object object = MultiEndpointPool.this.countersSync;
            synchronized (object) {
                MultiEndpointPool.this.poolSize--;
                prioritizedPool = MultiEndpointPool.this.getPrioritizedPool();
            }
            if (prioritizedPool != null) {
                prioritizedPool.createConnectionIfPossible();
                return;
            }
            super.onCloseConnection(info);
        }

        private void onMaxPoolSizeHit() {
            if (this.maxPoolSizeHits++ == 0) {
                if (this.size() > 0) {
                    MultiEndpointPool.this.maxPoolSizeHitsChain.offerLast(this.maxPoolSizeHitsLink);
                } else {
                    Link head = MultiEndpointPool.this.maxPoolSizeHitsChain.getFirstLink();
                    if (head != null) {
                        this.maxPoolSizeHits = ((EndpointPoolImpl)head.getValue()).maxPoolSizeHits;
                    }
                    MultiEndpointPool.this.maxPoolSizeHitsChain.offerFirst(this.maxPoolSizeHitsLink);
                }
            } else {
                Link prev = this.maxPoolSizeHitsLink.prev;
                if (prev != null && this.maxPoolSizeHits > ((EndpointPoolImpl)prev.getValue()).maxPoolSizeHits) {
                    MultiEndpointPool.this.maxPoolSizeHitsChain.moveTowardsHead(this.maxPoolSizeHitsLink);
                }
            }
        }
    }

    public static interface EndpointPoolCustomizer<E> {
        public void customize(Endpoint<E> var1, EndpointPoolBuilder<E> var2);
    }
}

