/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;

public class HttpParser {
    private static final String SPACE_ENTITY = "%20";
    private static final String PLUS_SIGN = "\\+";
    private static final String CONTENT_DISPOSITION_PART_HEADER = "Content-Disposition";
    private static final String NAME_ATTRIBUTE = "name";

    public static String extractPath(String uri) {
        String path = uri;
        int i = path.indexOf(63);
        if (i > -1) {
            path = path.substring(0, i);
        }
        return path;
    }

    public static Collection<HttpPart> parseMultipartContent(InputStream content, String contentType) throws IOException {
        MimeMultipart mimeMultipart = null;
        ArrayList parts = Lists.newArrayList();
        try {
            mimeMultipart = new MimeMultipart((DataSource)new ByteArrayDataSource(content, contentType));
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
        try {
            int partCount = mimeMultipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                String contentDisposition;
                String filename;
                BodyPart part = mimeMultipart.getBodyPart(i);
                String partName = filename = part.getFileName();
                String[] contentDispositions = part.getHeader(CONTENT_DISPOSITION_PART_HEADER);
                if (contentDispositions != null && (contentDisposition = contentDispositions[0]).contains(NAME_ATTRIBUTE)) {
                    partName = contentDisposition.substring(contentDisposition.indexOf(NAME_ATTRIBUTE) + NAME_ATTRIBUTE.length() + 2);
                    partName = partName.substring(0, partName.indexOf("\""));
                }
                HttpPart httpPart = new HttpPart(partName, filename, IOUtils.toByteArray((InputStream)part.getInputStream()), part.getContentType(), part.getSize());
                Enumeration headers = part.getAllHeaders();
                while (headers.hasMoreElements()) {
                    Header header = (Header)headers.nextElement();
                    httpPart.addHeader(header.getName(), header.getValue());
                }
                parts.add(httpPart);
            }
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
        return parts;
    }

    public static String normalizePathWithSpacesOrEncodedSpaces(String path) {
        return path.replaceAll(SPACE_ENTITY, " ").replaceAll(PLUS_SIGN, " ");
    }
}

