/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.service.server.grizzly.BaseResponseCompletionHandler;

public class ResponseCompletionHandler
extends BaseResponseCompletionHandler {
    private final FilterChainContext ctx;
    private final HttpResponsePacket httpResponsePacket;
    private final HttpContent httpResponseContent;
    private final ResponseStatusCallback responseStatusCallback;
    private boolean isDone;
    private boolean contentSend;

    public ResponseCompletionHandler(FilterChainContext ctx, HttpRequestPacket httpRequestPacket, HttpResponse httpResponse, ResponseStatusCallback responseStatusCallback) {
        Preconditions.checkArgument((!(httpResponse.getEntity() instanceof InputStreamHttpEntity) ? 1 : 0) != 0, (String)"response entity cannot be input stream");
        this.ctx = ctx;
        this.httpResponsePacket = this.buildHttpResponsePacket(httpRequestPacket, httpResponse);
        this.httpResponseContent = this.buildResponseContent(httpResponse);
        this.responseStatusCallback = responseStatusCallback;
    }

    public HttpContent buildResponseContent(HttpResponse httpResponse) {
        HttpEntity body = httpResponse.getEntity();
        Buffer grizzlyBuffer = null;
        if (body != null && !(body instanceof EmptyHttpEntity)) {
            if (body instanceof ByteArrayHttpEntity) {
                grizzlyBuffer = Buffers.wrap((MemoryManager)this.ctx.getMemoryManager(), (byte[])((ByteArrayHttpEntity)body).getContent());
            } else {
                throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)"At this point only a ByteArray entity is allowed"));
            }
        }
        HttpContent.Builder contentBuilder = HttpContent.builder((HttpHeader)this.httpResponsePacket);
        if (httpResponse.getHeaderValueIgnoreCase("Content-Length") != null) {
            contentBuilder.last(true);
        }
        return contentBuilder.content(grizzlyBuffer).build();
    }

    public void start() throws IOException {
        this.sendResponse();
    }

    public void sendResponse() throws IOException {
        if (!this.contentSend) {
            this.contentSend = true;
            this.isDone = !this.httpResponsePacket.isChunked();
            this.ctx.write((Object)this.httpResponseContent, (CompletionHandler)this);
            return;
        }
        this.isDone = true;
        this.ctx.write((Object)this.httpResponsePacket.httpTrailerBuilder().build(), (CompletionHandler)this);
    }

    public void completed(WriteResult result) {
        try {
            if (!this.isDone) {
                this.sendResponse();
            } else {
                this.ctx.notifyDownstream(HttpServerFilter.RESPONSE_COMPLETE_EVENT);
                this.responseStatusCallback.responseSendSuccessfully();
                this.resume();
            }
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    @Override
    public void cancelled() {
        super.cancelled();
        this.responseStatusCallback.responseSendFailure((Throwable)new Exception("http response transferring cancelled"));
        this.resume();
    }

    @Override
    public void failed(Throwable throwable) {
        super.failed(throwable);
        this.resume();
    }

    private void resume() {
        this.ctx.resume(this.ctx.getStopAction());
    }
}

