/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.scheduler.SchedulerConfig;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.util.NetworkUtils;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.runtime.http.api.tcp.TcpServerSocketProperties;
import org.mule.service.http.impl.service.server.ContextHttpServerFactory;
import org.mule.service.http.impl.service.server.DefaultServerAddress;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.HttpServerManager;
import org.mule.service.http.impl.service.server.ServerIdentifier;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyServerManager;

public class HttpListenerConnectionManager
implements ContextHttpServerFactory,
Initialisable,
Disposable {
    public static final String SERVER_ALREADY_EXISTS_FORMAT = "A server in port(%s) already exists for ip(%s) or one overlapping it (0.0.0.0).";
    private static final String LISTENER_THREAD_NAME_PREFIX = "http.listener";
    private final SchedulerService schedulerService;
    private final SchedulerConfig schedulersConfig;
    private Scheduler selectorScheduler;
    private Scheduler workerScheduler;
    private Scheduler idleTimeoutScheduler;
    private final HttpListenerRegistry httpListenerRegistry = new HttpListenerRegistry();
    private HttpServerManager httpServerManager;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public HttpListenerConnectionManager(SchedulerService schedulerService, SchedulerConfig schedulersConfig) {
        this.schedulerService = schedulerService;
        this.schedulersConfig = schedulersConfig;
    }

    public void initialise() throws InitialisationException {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        DefaultTcpServerSocketProperties tcpServerSocketProperties = new DefaultTcpServerSocketProperties();
        this.selectorScheduler = this.schedulerService.customScheduler(this.schedulersConfig.withMaxConcurrentTasks(Runtime.getRuntime().availableProcessors() + 1).withName(LISTENER_THREAD_NAME_PREFIX), Integer.MAX_VALUE);
        this.workerScheduler = this.schedulerService.ioScheduler(this.schedulersConfig);
        this.idleTimeoutScheduler = this.schedulerService.ioScheduler(this.schedulersConfig.withName("http.listener.HttpIdleConnectionCloser"));
        this.httpServerManager = new GrizzlyServerManager((ExecutorService)this.selectorScheduler, (ExecutorService)this.workerScheduler, (ExecutorService)this.idleTimeoutScheduler, this.httpListenerRegistry, tcpServerSocketProperties);
    }

    public synchronized void dispose() {
        this.httpServerManager.dispose();
        this.idleTimeoutScheduler.stop();
        this.workerScheduler.stop();
        this.selectorScheduler.stop();
    }

    @Override
    public HttpServer create(HttpServerConfiguration configuration, String context) throws ConnectionException {
        ServerAddress serverAddress;
        String host = configuration.getHost();
        try {
            serverAddress = this.createServerAddress(host, configuration.getPort());
        }
        catch (UnknownHostException e) {
            throw new ConnectionException(String.format("Cannot resolve host %s", host), (Throwable)e);
        }
        TlsContextFactory tlsContextFactory = configuration.getTlsContextFactory();
        HttpServer httpServer = tlsContextFactory == null ? this.createServer(serverAddress, configuration.getSchedulerSupplier(), configuration.isUsePersistentConnections(), configuration.getConnectionIdleTimeout(), new ServerIdentifier(context, configuration.getName())) : this.createSslServer(serverAddress, tlsContextFactory, configuration.getSchedulerSupplier(), configuration.isUsePersistentConnections(), configuration.getConnectionIdleTimeout(), new ServerIdentifier(context, configuration.getName()));
        return httpServer;
    }

    @Override
    public HttpServer lookup(ServerIdentifier identifier) throws ServerNotFoundException {
        return this.httpServerManager.lookupServer(identifier);
    }

    public HttpServer createServer(ServerAddress serverAddress, Supplier<Scheduler> schedulerSupplier, boolean usePersistentConnections, int connectionIdleTimeout, ServerIdentifier identifier) {
        if (!this.containsServerFor(serverAddress, identifier)) {
            try {
                return this.httpServerManager.createServerFor(serverAddress, schedulerSupplier, usePersistentConnections, connectionIdleTimeout, identifier);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format(SERVER_ALREADY_EXISTS_FORMAT, serverAddress.getPort(), serverAddress.getIp())));
    }

    public boolean containsServerFor(ServerAddress serverAddress, ServerIdentifier identifier) {
        return this.httpServerManager.containsServerFor(serverAddress, identifier);
    }

    public HttpServer createSslServer(ServerAddress serverAddress, TlsContextFactory tlsContext, Supplier<Scheduler> schedulerSupplier, boolean usePersistentConnections, int connectionIdleTimeout, ServerIdentifier identifier) {
        if (!this.containsServerFor(serverAddress, identifier)) {
            try {
                return this.httpServerManager.createSslServerFor(tlsContext, schedulerSupplier, serverAddress, usePersistentConnections, connectionIdleTimeout, identifier);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format(SERVER_ALREADY_EXISTS_FORMAT, serverAddress.getPort(), serverAddress.getIp())));
    }

    private ServerAddress createServerAddress(String host, int port) throws UnknownHostException {
        return new DefaultServerAddress(NetworkUtils.getLocalHostIp((String)host), port);
    }

    private class DefaultTcpServerSocketProperties
    implements TcpServerSocketProperties {
        private DefaultTcpServerSocketProperties() {
        }

        public Integer getSendBufferSize() {
            return null;
        }

        public Integer getReceiveBufferSize() {
            return null;
        }

        public Integer getClientTimeout() {
            return null;
        }

        public Boolean getSendTcpNoDelay() {
            return true;
        }

        public Integer getLinger() {
            return null;
        }

        public Boolean getKeepAlive() {
            return false;
        }

        public Boolean getReuseAddress() {
            return true;
        }

        public Integer getReceiveBacklog() {
            return 50;
        }

        public Integer getServerTimeout() {
            return null;
        }
    }
}

