/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server;

import com.google.common.base.Joiner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.service.http.impl.service.server.DefaultRequestHandlerManager;
import org.mule.service.http.impl.service.server.DefaultServerAddress;
import org.mule.service.http.impl.service.server.NoListenerRequestHandler;
import org.mule.service.http.impl.service.server.NoMethodRequestHandler;
import org.mule.service.http.impl.service.server.RequestHandlerProvider;
import org.mule.service.http.impl.service.server.ServerAddressMap;
import org.mule.service.http.impl.service.server.ServiceTemporarilyUnavailableListenerRequestHandler;
import org.mule.service.http.impl.service.server.grizzly.DefaultMethodRequestMatcher;
import org.mule.service.http.impl.service.server.grizzly.HttpParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpListenerRegistry
implements RequestHandlerProvider {
    private static final String WILDCARD_CHARACTER = "*";
    private static final String SLASH = "/";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServerAddressMap<HttpServer> serverAddressToServerMap = new ServerAddressMap();
    private final Map<HttpServer, ServerAddressRequestHandlerRegistry> requestHandlerPerServerAddress = new HashMap<HttpServer, ServerAddressRequestHandlerRegistry>();

    public synchronized RequestHandlerManager addRequestHandler(HttpServer server, RequestHandler requestHandler, PathAndMethodRequestMatcher requestMatcher) {
        ServerAddressRequestHandlerRegistry serverAddressRequestHandlerRegistry = this.requestHandlerPerServerAddress.get(server);
        if (serverAddressRequestHandlerRegistry == null) {
            serverAddressRequestHandlerRegistry = new ServerAddressRequestHandlerRegistry();
            this.requestHandlerPerServerAddress.put(server, serverAddressRequestHandlerRegistry);
            this.serverAddressToServerMap.put(server.getServerAddress(), server);
        }
        return serverAddressRequestHandlerRegistry.addRequestHandler(requestMatcher, requestHandler);
    }

    public synchronized void removeHandlersFor(HttpServer server) {
        this.requestHandlerPerServerAddress.remove(server);
        this.serverAddressToServerMap.remove(server.getServerAddress());
    }

    @Override
    public RequestHandler getRequestHandler(String ip, int port, HttpRequest request) {
        ServerAddressRequestHandlerRegistry serverAddressRequestHandlerRegistry;
        HttpServer server;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking RequestHandler for request: " + request.getPath());
        }
        if ((server = this.serverAddressToServerMap.get(new DefaultServerAddress(ip, port))) != null && !server.isStopping() && !server.isStopped() && (serverAddressRequestHandlerRegistry = this.requestHandlerPerServerAddress.get(server)) != null) {
            return serverAddressRequestHandlerRegistry.findRequestHandler(request);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("No RequestHandler found for request: " + request.getPath());
        }
        return NoListenerRequestHandler.getInstance();
    }

    private boolean isUriParameter(String pathPart) {
        return (pathPart.startsWith("{") || pathPart.startsWith("/{")) && pathPart.endsWith("}");
    }

    private String getLastPathPortion(String possibleCollisionRequestMatcherPath) {
        String[] parts = this.splitPath(possibleCollisionRequestMatcherPath);
        if (parts.length == 0) {
            return "";
        }
        return parts[parts.length - 1];
    }

    private boolean isSameDepth(String possibleCollisionRequestMatcherPath, String newListenerRequestMatcherPath) {
        return this.getPathPartsSize(possibleCollisionRequestMatcherPath) == this.getPathPartsSize(newListenerRequestMatcherPath);
    }

    private int getPathPartsSize(String path) {
        int pathSize = this.splitPath(path).length - 1;
        return pathSize += path.endsWith(SLASH) ? 1 : 0;
    }

    private String[] splitPath(String path) {
        if (path.endsWith(SLASH)) {
            path = path.substring(0, path.length() - 1);
        }
        return path.split(SLASH, -1);
    }

    private boolean isCatchAllPath(String path) {
        return WILDCARD_CHARACTER.equals(path);
    }

    public class RequestHandlerMatcherPair {
        private PathAndMethodRequestMatcher requestMatcher;
        private RequestHandler requestHandler;
        private boolean running = true;

        private RequestHandlerMatcherPair(PathAndMethodRequestMatcher requestMatcher, RequestHandler requestHandler) {
            this.requestMatcher = requestMatcher;
            this.requestHandler = requestHandler;
        }

        public PathAndMethodRequestMatcher getRequestMatcher() {
            return this.requestMatcher;
        }

        public RequestHandler getRequestHandler() {
            return this.requestHandler;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void setIsRunning(Boolean running) {
            this.running = running;
        }
    }

    public class PathMap {
        List<RequestHandlerMatcherPair> requestHandlerMatcherPairs = new ArrayList<RequestHandlerMatcherPair>();
        private Map<String, PathMap> subPaths = new HashMap<String, PathMap>();
        private PathMap catchAllPathMap;
        private PathMap catchAllCurrentPathMap;

        public PathMap getCatchAllPathMap() {
            return this.catchAllPathMap;
        }

        public PathMap getCatchAllCurrentPathMap() {
            return this.catchAllCurrentPathMap;
        }

        public PathMap getChildPathMap(String subPath, String nextSubPath) {
            if (HttpListenerRegistry.this.isCatchAllPath(subPath) || HttpListenerRegistry.this.isUriParameter(subPath) || this.isViablePath(subPath, nextSubPath) && !this.matchesNextSubPaths(subPath, nextSubPath)) {
                return this.getCatchAllCurrentPathMap();
            }
            PathMap pathMap = this.subPaths.get(subPath);
            return pathMap;
        }

        private boolean isViablePath(String subPath, String nextSubPath) {
            if (this.getCatchAllCurrentPathMap() != null && nextSubPath != null) {
                return this.getCatchAllCurrentPathMap().subPaths.containsKey(nextSubPath);
            }
            return false;
        }

        private boolean matchesNextSubPaths(String subPath, String nextSubPath) {
            PathMap nextPathMap;
            if (this.subPaths.containsKey(subPath) && (nextPathMap = this.subPaths.get(subPath)).getSubPaths() != null) {
                return nextPathMap.getSubPaths().containsKey(nextSubPath);
            }
            return false;
        }

        public PathMap getLastChildPathMap(String subPath) {
            if (HttpListenerRegistry.this.isCatchAllPath(subPath) || HttpListenerRegistry.this.isUriParameter(subPath)) {
                return this.getCatchAllCurrentPathMap();
            }
            PathMap pathMap = this.subPaths.get(subPath);
            return pathMap;
        }

        public void addRequestHandlerMatcherPair(RequestHandlerMatcherPair requestHandlerMatcherPair) {
            this.requestHandlerMatcherPairs.add(requestHandlerMatcherPair);
        }

        public void addChildPathMap(String path, PathMap pathMap) {
            if (path.equals(HttpListenerRegistry.WILDCARD_CHARACTER) || path.endsWith("}")) {
                this.catchAllCurrentPathMap = pathMap;
            } else {
                this.subPaths.put(path, pathMap);
            }
        }

        public Map<String, PathMap> getSubPaths() {
            return this.subPaths;
        }

        public List<RequestHandlerMatcherPair> getRequestHandlerMatcherPairs() {
            return this.requestHandlerMatcherPairs;
        }

        public void addWildcardRequestHandler(RequestHandlerMatcherPair requestHandlerMatcherPair) {
            if (this.catchAllPathMap == null) {
                this.catchAllPathMap = new PathMap();
            }
            this.catchAllPathMap.addRequestHandlerMatcherPair(requestHandlerMatcherPair);
        }

        public boolean removeRequestHandlerMatcherPair(RequestHandlerMatcherPair requestHandlerMatcherPair) {
            if (this.requestHandlerMatcherPairs.remove(requestHandlerMatcherPair)) {
                return true;
            }
            if (this.catchAllPathMap != null && this.catchAllPathMap.removeRequestHandlerMatcherPair(requestHandlerMatcherPair)) {
                return true;
            }
            return this.catchAllCurrentPathMap != null && this.catchAllCurrentPathMap.removeRequestHandlerMatcherPair(requestHandlerMatcherPair);
        }
    }

    public class ServerAddressRequestHandlerRegistry {
        private PathMap serverRequestHandler;
        private PathMap rootPathMap;
        private PathMap catchAllPathMap;
        private Set<String> paths;
        private LoadingCache<String, Stack<PathMap>> pathMapSearchCache;

        public ServerAddressRequestHandlerRegistry() {
            this.rootPathMap = new PathMap();
            this.catchAllPathMap = new PathMap();
            this.paths = new HashSet<String>();
            this.pathMapSearchCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, Stack<PathMap>>(){

                public Stack<PathMap> load(String path) {
                    return ServerAddressRequestHandlerRegistry.this.findPossibleRequestHandlers(path);
                }
            });
        }

        public synchronized RequestHandlerManager addRequestHandler(PathAndMethodRequestMatcher requestMatcher, RequestHandler requestHandler) {
            PathMap requestHandlerOwner;
            RequestHandlerMatcherPair addedRequestHandlerMatcherPair;
            this.pathMapSearchCache.invalidateAll();
            String requestMatcherPath = HttpParser.normalizePathWithSpacesOrEncodedSpaces(requestMatcher.getPath());
            Preconditions.checkArgument((requestMatcherPath.startsWith(HttpListenerRegistry.SLASH) || requestMatcherPath.equals(HttpListenerRegistry.WILDCARD_CHARACTER) ? 1 : 0) != 0, (String)"path parameter must start with /");
            this.validateCollision(requestMatcher);
            List matcherMethods = requestMatcher.getMethodRequestMatcher().getMethods();
            this.paths.add(this.getMethodAndPath(DefaultMethodRequestMatcher.getMethodsListRepresentation(matcherMethods), requestMatcherPath));
            PathMap currentPathMap = this.rootPathMap;
            if (requestMatcherPath.equals(HttpListenerRegistry.WILDCARD_CHARACTER)) {
                this.serverRequestHandler = new PathMap();
                addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
                requestHandlerOwner = this.serverRequestHandler;
                this.serverRequestHandler.addRequestHandlerMatcherPair(addedRequestHandlerMatcherPair);
            } else if (requestMatcherPath.equals("/*")) {
                addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
                requestHandlerOwner = this.catchAllPathMap;
                this.catchAllPathMap.addRequestHandlerMatcherPair(addedRequestHandlerMatcherPair);
            } else if (requestMatcherPath.equals(HttpListenerRegistry.SLASH)) {
                addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
                requestHandlerOwner = this.rootPathMap;
                this.rootPathMap.addRequestHandlerMatcherPair(addedRequestHandlerMatcherPair);
            } else {
                String[] pathParts = HttpListenerRegistry.this.splitPath(requestMatcherPath);
                int insertionLevel = HttpListenerRegistry.this.getPathPartsSize(requestMatcherPath);
                for (int i = 1; i < insertionLevel - 1; ++i) {
                    String currentPath = pathParts[i];
                    PathMap pathMap = currentPathMap.getChildPathMap(currentPath, null);
                    if (i != insertionLevel - 1 && pathMap == null) {
                        pathMap = new PathMap();
                        currentPathMap.addChildPathMap(currentPath, pathMap);
                    }
                    currentPathMap = pathMap;
                }
                String currentPath = pathParts[insertionLevel - 1];
                PathMap pathMap = currentPathMap.getLastChildPathMap(currentPath);
                if (pathMap == null) {
                    pathMap = new PathMap();
                    currentPathMap.addChildPathMap(currentPath, pathMap);
                }
                if (requestMatcherPath.endsWith(HttpListenerRegistry.WILDCARD_CHARACTER)) {
                    addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
                    pathMap.addWildcardRequestHandler(addedRequestHandlerMatcherPair);
                    requestHandlerOwner = pathMap;
                } else {
                    addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
                    pathMap.addRequestHandlerMatcherPair(addedRequestHandlerMatcherPair);
                    requestHandlerOwner = pathMap;
                }
            }
            return new DefaultRequestHandlerManager(requestHandlerOwner, addedRequestHandlerMatcherPair);
        }

        private void validateCollision(PathAndMethodRequestMatcher newListenerRequestMatcher) {
            String newListenerRequestMatcherPath = newListenerRequestMatcher.getPath();
            Stack<PathMap> possibleRequestHandlers = this.findPossibleRequestHandlersFromCache(newListenerRequestMatcherPath);
            for (PathMap possibleRequestHandler : possibleRequestHandlers) {
                List<RequestHandlerMatcherPair> requestHandlerMatcherPairs = possibleRequestHandler.getRequestHandlerMatcherPairs();
                for (RequestHandlerMatcherPair requestHandlerMatcherPair : requestHandlerMatcherPairs) {
                    String newListenerRequestMatcherLastPathPart;
                    String possibleCollisionLastPathPart;
                    PathAndMethodRequestMatcher requestMatcher = requestHandlerMatcherPair.getRequestMatcher();
                    String possibleCollisionRequestMatcherPath = requestMatcher.getPath();
                    if (!HttpListenerRegistry.this.isSameDepth(possibleCollisionRequestMatcherPath, newListenerRequestMatcherPath) || !newListenerRequestMatcher.getMethodRequestMatcher().intersectsWith(requestMatcher.getMethodRequestMatcher()) || !((possibleCollisionLastPathPart = HttpListenerRegistry.this.getLastPathPortion(possibleCollisionRequestMatcherPath)).equals(newListenerRequestMatcherLastPathPart = HttpListenerRegistry.this.getLastPathPortion(newListenerRequestMatcherPath)) || HttpListenerRegistry.this.isCatchAllPath(possibleCollisionLastPathPart) && HttpListenerRegistry.this.isCatchAllPath(newListenerRequestMatcherLastPathPart) || HttpListenerRegistry.this.isCatchAllPath(possibleCollisionLastPathPart) && HttpListenerRegistry.this.isUriParameter(newListenerRequestMatcherLastPathPart) || HttpListenerRegistry.this.isUriParameter(possibleCollisionLastPathPart) && HttpListenerRegistry.this.isCatchAllPath(newListenerRequestMatcherLastPathPart)) && (!HttpListenerRegistry.this.isUriParameter(possibleCollisionLastPathPart) || !HttpListenerRegistry.this.isUriParameter(newListenerRequestMatcherLastPathPart))) continue;
                    throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format("Already exists a listener matching that path and methods. Listener matching %s new listener %s", requestMatcher, newListenerRequestMatcher)));
                }
            }
        }

        public RequestHandler findRequestHandler(HttpRequest request) {
            String path = HttpParser.normalizePathWithSpacesOrEncodedSpaces(request.getPath());
            Preconditions.checkArgument((boolean)path.startsWith(HttpListenerRegistry.SLASH), (String)"path parameter must start with /");
            Stack<PathMap> foundPaths = this.findPossibleRequestHandlersFromCache(path);
            boolean methodNotAllowed = false;
            RequestHandlerMatcherPair requestHandlerMatcherPair = null;
            while (!foundPaths.empty()) {
                PathMap pathMap = foundPaths.pop();
                List<RequestHandlerMatcherPair> requestHandlerMatcherPairs = pathMap.getRequestHandlerMatcherPairs();
                if (requestHandlerMatcherPairs == null && pathMap.getCatchAllPathMap() != null) {
                    requestHandlerMatcherPairs = pathMap.getCatchAllPathMap().requestHandlerMatcherPairs;
                }
                if ((requestHandlerMatcherPair = this.findRequestHandlerMatcherPair(requestHandlerMatcherPairs, request)) != null) break;
                if (requestHandlerMatcherPairs.isEmpty()) continue;
                methodNotAllowed = true;
            }
            if (requestHandlerMatcherPair == null) {
                if (HttpListenerRegistry.this.logger.isInfoEnabled()) {
                    HttpListenerRegistry.this.logger.info("No listener found for request: " + this.getMethodAndPath(request.getMethod(), request.getPath()));
                    HttpListenerRegistry.this.logger.info("Available listeners are: [{}]", (Object)Joiner.on((String)", ").join(this.paths));
                }
                if (methodNotAllowed) {
                    return NoMethodRequestHandler.getInstance();
                }
                return NoListenerRequestHandler.getInstance();
            }
            if (!requestHandlerMatcherPair.isRunning()) {
                return ServiceTemporarilyUnavailableListenerRequestHandler.getInstance();
            }
            return requestHandlerMatcherPair.getRequestHandler();
        }

        private String getMethodAndPath(String method, String path) {
            return "(" + method + ")" + path;
        }

        private Stack<PathMap> findPossibleRequestHandlersFromCache(String path) {
            return this.findPossibleRequestHandlers(path);
        }

        private Stack<PathMap> findPossibleRequestHandlers(String path) {
            PathMap currentPathMap = this.rootPathMap;
            PathMap auxPathMap = null;
            String[] pathParts = HttpListenerRegistry.this.splitPath(path);
            Stack<PathMap> foundPaths = new Stack<PathMap>();
            foundPaths.add(this.catchAllPathMap);
            if (path.equals(HttpListenerRegistry.WILDCARD_CHARACTER)) {
                foundPaths.push(this.serverRequestHandler);
                return foundPaths;
            }
            if (path.equals(HttpListenerRegistry.SLASH)) {
                foundPaths.push(this.rootPathMap);
                return foundPaths;
            }
            for (int i = 1; i < pathParts.length && currentPathMap != null; ++i) {
                String currentPath = pathParts[i];
                PathMap pathMap = currentPathMap.getChildPathMap(currentPath, i < pathParts.length - 1 ? pathParts[i + 1] : null);
                if (pathMap == null) {
                    this.addCatchAllPathMapIfNotNull(currentPathMap, foundPaths);
                    pathMap = currentPathMap.getCatchAllCurrentPathMap();
                } else if (pathMap.getCatchAllPathMap() != null) {
                    auxPathMap = pathMap;
                }
                if (i == pathParts.length - 1) {
                    if (auxPathMap != null) {
                        this.addCatchAllPathMapIfNotNull(auxPathMap, foundPaths);
                    }
                    if (pathMap != null) {
                        this.addCatchAllPathMapIfNotNull(pathMap, foundPaths);
                        foundPaths.push(pathMap);
                    } else {
                        this.addCatchAllPathMapIfNotNull(currentPathMap, foundPaths);
                    }
                }
                currentPathMap = pathMap;
            }
            return foundPaths;
        }

        private void addCatchAllPathMapIfNotNull(PathMap currentPathMap, Stack<PathMap> foundPaths) {
            PathMap catchAllPathMap = currentPathMap.getCatchAllPathMap();
            if (catchAllPathMap != null) {
                foundPaths.push(catchAllPathMap);
            }
        }

        private RequestHandlerMatcherPair findRequestHandlerMatcherPair(List<RequestHandlerMatcherPair> requestHandlerMatcherPairs, HttpRequest request) {
            for (RequestHandlerMatcherPair requestHandlerMatcherPair : requestHandlerMatcherPairs) {
                if (!requestHandlerMatcherPair.getRequestMatcher().matches(request)) continue;
                return requestHandlerMatcherPair;
            }
            return null;
        }
    }
}

