/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;

@Feature(value="HTTP Service")
@Story(value="Multipart")
public class HttpClientPartTypeTestCase
extends AbstractHttpClientTestCase {
    private byte[] dataBytes = "{ 'I am a JSON attachment!' }".getBytes(StandardCharsets.UTF_8);
    private HttpClient client;

    @Before
    public void createClient() {
        HttpClientConfiguration clientConf = new HttpClientConfiguration.Builder().setName("multipart-test").build();
        this.client = this.service.getClientFactory().create(clientConf);
        this.client.start();
    }

    @After
    public void closeClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder response = HttpResponse.builder();
        try {
            Collection parts = request.getEntity().getParts();
            if (parts.size() == 1 && parts.stream().anyMatch(part -> MediaType.JSON.toRfcString().equals(part.getContentType()))) {
                return ((HttpResponseBuilder)response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).entity((HttpEntity)new ByteArrayHttpEntity(HttpConstants.HttpStatus.OK.getReasonPhrase().getBytes()))).build();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).build();
    }

    @Test
    @Description(value="Verify that parts content type is preserved.")
    public void partContentTypeIsPreserved() throws Exception {
        HttpPart part = new HttpPart("someJson", this.dataBytes, MediaType.JSON.toRfcString(), this.dataBytes.length);
        MultipartHttpEntity multipart = new MultipartHttpEntity(Collections.singletonList(part));
        HttpResponse response = this.client.send(((HttpRequestBuilder)HttpRequest.builder().method(HttpConstants.Method.POST).uri(this.getUri()).entity((HttpEntity)multipart)).build(), 10000, true, null);
        Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"OK")));
    }
}

