/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import io.qameta.allure.Feature;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@Feature(value="HTTP Service")
public class HttpServerBindTestCase
extends AbstractHttpServiceTestCase {
    @Rule
    public DynamicPort usedPort = new DynamicPort("usedPort");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ServerSocket serverSocket;

    @Before
    public void setUp() throws Exception {
        this.service.start();
        this.serverSocket = new ServerSocket();
        this.serverSocket.bind(new InetSocketAddress("localhost", this.usedPort.getNumber()));
    }

    @After
    public void tearDown() throws Exception {
        this.serverSocket.close();
        this.service.stop();
    }

    @Test
    public void cannotBindToUsedPort() throws Exception {
        HttpServer server = this.service.getServerFactory().create(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.usedPort.getNumber()).setName("failingServer").build());
        try {
            this.expectedException.expectMessage("Address already in use");
            server.start();
        }
        finally {
            server.stop();
            server.dispose();
        }
    }
}

