/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.InputStream;
import java.util.Collections;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@Feature(value="HTTP Service")
@Story(value="Multipart")
public class HttpServerMixedPartTestCase
extends AbstractHttpServiceTestCase {
    private static final String MIXED_CONTENT = "--the-boundary\r\nContent-Type: text/plain\r\nCustom: myHeader\r\nContent-Disposition: attachment; name=\"field\"\r\n\r\nMy data here\r\n--the-boundary--\r\n";
    @Rule
    public DynamicPort port = new DynamicPort("port");
    private HttpServer server;

    @Before
    public void setUp() throws Exception {
        this.server = this.service.getServerFactory().create(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.getNumber()).setName("parts-test").build());
        this.server.start();
        this.server.addRequestHandler("/", (requestContext, responseCallback) -> {
            String data = "My data here";
            HttpPart part = new HttpPart("field", data.getBytes(), MediaType.TEXT.toRfcString(), data.length());
            part.addHeader("Custom", "myHeader");
            responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new MultipartHttpEntity(Collections.singletonList(part)))).addHeader("Content-Type", MediaType.MULTIPART_MIXED.toRfcString() + "; boundary=\"the-boundary\"")).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
        });
    }

    @After
    public void tearDown() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void handlesMultipartMixed() throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpPost = new HttpGet("http://localhost:" + this.port.getValue());
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)MIXED_CONTENT)));
            }
        }
    }
}

