/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import io.qameta.allure.Feature;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpProbe;
import org.glassfish.grizzly.monitoring.MonitoringConfig;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.service.http.impl.service.client.HttpMessageLogger;
import org.mule.service.http.impl.service.client.LoggerTransportCustomizer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
@Feature(value="HTTP Service")
public class LoggerTransportCustomizerTestCase
extends AbstractMuleTestCase {
    @Mock
    private FilterChainBuilder mockFilterChainBuilder;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpCodecFilter mockHttpCodeFilter;
    @Mock
    private MuleRuntimeException mockMuleRuntimeException;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private LoggerTransportCustomizer loggerTransportCustomizer = new LoggerTransportCustomizer();

    @Test
    public void httpMessageLoggerIsAdded() {
        Mockito.when((Object)this.mockFilterChainBuilder.get(Matchers.anyInt())).thenReturn((Object)this.mockHttpCodeFilter);
        this.loggerTransportCustomizer.customize(null, this.mockFilterChainBuilder);
        ((MonitoringConfig)Mockito.verify((Object)this.mockHttpCodeFilter.getMonitoringConfig())).addProbes((Object[])new HttpProbe[]{(HttpProbe)Matchers.isA(HttpMessageLogger.class)});
    }

    @Test
    public void noHttpCodeFilterFound() {
        Mockito.when((Object)this.mockFilterChainBuilder.get(Matchers.anyInt())).thenThrow(new Throwable[]{this.mockMuleRuntimeException});
        this.expectedException.expect(MuleRuntimeException.class);
        this.loggerTransportCustomizer.customize(null, this.mockFilterChainBuilder);
    }
}

