/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.utils.BufferInputStream;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.BaseHttpMessage;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.mule.runtime.http.api.utils.UriCache;
import org.mule.service.http.impl.service.domain.entity.multipart.StreamedMultipartHttpEntity;
import org.mule.service.http.impl.service.server.grizzly.BlockingTransferInputStream;

public class GrizzlyHttpRequestAdapter
extends BaseHttpMessage
implements HttpRequest {
    private static final String PROTOCOL = "http";
    private final HttpRequestPacket requestPacket;
    private final InputStream requestContent;
    private final long contentLength;
    private final boolean isTransferEncodingChunked;
    private HttpProtocol protocol;
    private URI uri;
    private String path;
    private String method;
    private HttpEntity body;
    private MultiMap<String, String> headers;
    private MultiMap<String, String> queryParams;

    public GrizzlyHttpRequestAdapter(FilterChainContext filterChainContext, HttpContent httpContent) {
        this.requestPacket = (HttpRequestPacket)httpContent.getHttpHeader();
        this.isTransferEncodingChunked = this.requestPacket.isChunked();
        long contentLengthAsLong = -1L;
        String contentLengthAsString = this.requestPacket.getHeader("Content-Length");
        if (contentLengthAsString != null) {
            contentLengthAsLong = Long.parseLong(contentLengthAsString);
        }
        this.contentLength = contentLengthAsLong;
        this.requestContent = httpContent.isLast() ? new BufferInputStream(httpContent.getContent()) : new BlockingTransferInputStream((HttpHeader)this.requestPacket, filterChainContext);
    }

    public HttpProtocol getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.requestPacket.getProtocol() == Protocol.HTTP_1_0 ? HttpProtocol.HTTP_1_0 : HttpProtocol.HTTP_1_1;
        }
        return this.protocol;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.requestPacket.getRequestURI();
        }
        return this.path;
    }

    public String getMethod() {
        if (this.method == null) {
            this.method = this.requestPacket.getMethod().getMethodString();
        }
        return this.method;
    }

    public Collection<String> getHeaderNames() {
        if (this.headers == null) {
            this.initializeHeaders();
        }
        return this.headers.keySet();
    }

    public String getHeaderValue(String headerName) {
        if (this.headers == null) {
            this.initializeHeaders();
        }
        return (String)this.headers.get((Object)headerName);
    }

    public Collection<String> getHeaderValues(String headerName) {
        if (this.headers == null) {
            this.initializeHeaders();
        }
        return this.headers.getAll((Object)headerName);
    }

    private void initializeHeaders() {
        this.headers = new MultiMap();
        for (String grizzlyHeaderName : this.requestPacket.getHeaders().names()) {
            Iterable headerValues = this.requestPacket.getHeaders().values(grizzlyHeaderName);
            for (String headerValue : headerValues) {
                this.headers.put((Object)grizzlyHeaderName, (Object)headerValue);
            }
        }
        this.headers = this.headers.toImmutableMultiMap();
    }

    public HttpEntity getEntity() {
        if (this.body == null) {
            String contentTypeValue = this.getHeaderValueIgnoreCase("Content-Type");
            this.body = contentTypeValue != null && contentTypeValue.contains(MediaType.MULTIPART_MIXED.getPrimaryType()) ? (this.contentLength >= 0L ? new StreamedMultipartHttpEntity(this.requestContent, contentTypeValue, this.contentLength) : new StreamedMultipartHttpEntity(this.requestContent, contentTypeValue)) : (this.contentLength > 0L ? new InputStreamHttpEntity(this.requestContent, Long.valueOf(this.contentLength)) : (this.contentLength == 0L ? new EmptyHttpEntity() : new InputStreamHttpEntity(this.requestContent)));
        }
        return this.body;
    }

    public MultiMap<String, String> getQueryParams() {
        if (this.queryParams == null) {
            this.queryParams = HttpEncoderDecoderUtils.decodeQueryString((String)this.requestPacket.getQueryString());
        }
        return this.queryParams;
    }

    public URI getUri() {
        if (this.uri == null) {
            this.uri = UriCache.getUriFromString((String)("http://" + this.requestPacket.getLocalName() + ":" + this.requestPacket.getLocalPort() + this.requestPacket.getRequestURI() + (StringUtils.isEmpty((String)this.requestPacket.getQueryString()) ? "" : "?" + this.requestPacket.getQueryString())));
        }
        return this.uri;
    }
}

