/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpServerErrorRequestsTestCase
extends AbstractHttpServiceTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    private HttpServer server;

    public HttpServerErrorRequestsTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setUp() throws Exception {
        this.server = this.service.getServerFactory().create(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.getNumber()).setName("errors-test").build());
        this.server.start();
        this.server.addRequestHandler(Collections.singletonList(HttpConstants.Method.GET.name()), "/test", (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new ByteArrayHttpEntity("Success!".getBytes()))).addHeader("Content-Type", MediaType.TEXT.toRfcString())).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback()));
    }

    @After
    public void tearDown() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void methodNotAllowed() throws Exception {
        this.verifyErrorResponse((HttpRequestBase)new HttpPost(), "test", HttpConstants.HttpStatus.METHOD_NOT_ALLOWED, "Method not allowed for endpoint: /test");
    }

    @Test
    public void notFound() throws Exception {
        this.verifyErrorResponse((HttpRequestBase)new HttpGet(), "wat", HttpConstants.HttpStatus.NOT_FOUND, "No listener for endpoint: /wat");
    }

    private void verifyErrorResponse(HttpRequestBase httpRequest, String path, HttpConstants.HttpStatus expectedStatus, String expectedBody) throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            httpRequest.setURI(this.getUri(path));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);){
                Assert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)expectedStatus.getStatusCode()));
                Assert.assertThat((Object)response.getStatusLine().getReasonPhrase(), (Matcher)Matchers.is((Object)expectedStatus.getReasonPhrase()));
                Assert.assertThat((Object)response.getFirstHeader("Content-Type").getValue(), (Matcher)Matchers.is((Object)MediaType.TEXT.toRfcString()));
                Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Object)expectedBody));
            }
        }
    }

    private URI getUri(String path) {
        return URI.create(String.format("http://localhost:%s/%s", this.port.getValue(), path));
    }
}

