/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import io.qameta.allure.Story;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@Story(value="Multipart")
public class HttpServerPartsTestCase
extends AbstractHttpServiceTestCase {
    private static final String TEXT_BODY_FIELD_NAME = "field1";
    private static final String TEXT_BODY_FIELD_VALUE = "yes";
    private static final String BASE_PATH = "/";
    private static final String NO_HEADER = "/no-header";
    private static final String PARTIAL_HEADER = "/partial-header";
    private static final String FULL_HEADER = "/full-header";
    private static final String BOUNDARY_PART = "; boundary=\"the-boundary\"";
    @Rule
    public DynamicPort port = new DynamicPort("port");
    private HttpServer server;

    public HttpServerPartsTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setUp() throws Exception {
        this.server = this.service.getServerFactory().create(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.getNumber()).setName("parts-test").build());
        this.server.start();
        this.server.addRequestHandler(BASE_PATH, (requestContext, responseCallback) -> {
            AbstractHttpServiceTestCase.IgnoreResponseStatusCallback statusCallback = new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback();
            try {
                Collection parts = requestContext.getRequest().getEntity().getParts();
                responseCallback.responseReady(((HttpResponseBuilder)HttpResponse.builder().entity((org.mule.runtime.http.api.domain.entity.HttpEntity)new MultipartHttpEntity(parts))).build(), (ResponseStatusCallback)statusCallback);
            }
            catch (IOException e) {
                responseCallback.responseReady(HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).build(), (ResponseStatusCallback)statusCallback);
            }
        });
        this.server.addRequestHandler(NO_HEADER, (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)HttpResponse.builder().entity((org.mule.runtime.http.api.domain.entity.HttpEntity)new MultipartHttpEntity(this.createPart()))).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback()));
        this.server.addRequestHandler(PARTIAL_HEADER, (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((org.mule.runtime.http.api.domain.entity.HttpEntity)new MultipartHttpEntity(this.createPart()))).addHeader("Content-Type", "multipart/form-data")).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback()));
        this.server.addRequestHandler(FULL_HEADER, (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((org.mule.runtime.http.api.domain.entity.HttpEntity)new MultipartHttpEntity(this.createPart()))).addHeader("Content-Type", "multipart/form-data; boundary=\"the-boundary\"")).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback()));
    }

    @After
    public void tearDown() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void returnsOnlyOneContentTypeHeaderPerPart() throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(this.getUri(BASE_PATH));
            httpPost.setEntity(this.getMultipartEntity());
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                Assert.assertThat((Object)StringUtils.countMatches((CharSequence)IOUtils.toString((InputStream)response.getEntity().getContent()), (CharSequence)"Content-Type"), (Matcher)Is.is((Object)1));
            }
        }
    }

    @Test
    public void maintainsBoundaryWhenPresent() throws Exception {
        this.assertBoundaryMatch(FULL_HEADER, BOUNDARY_PART);
    }

    @Test
    public void addsBoundaryWhenNoHeaderIsPresent() throws Exception {
        this.assertBoundaryMatch(NO_HEADER, "; boundary=\"");
    }

    @Test
    public void addsBoundaryWhenNotPresent() throws Exception {
        this.assertBoundaryMatch(PARTIAL_HEADER, "; boundary=\"");
    }

    private void assertBoundaryMatch(String path, String boundaryPart) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(this.getUri(path));
            httpPost.setEntity(this.getMultipartEntity());
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                String contentType = response.getFirstHeader("Content-Type").getValue();
                Assert.assertThat((Object)contentType, (Matcher)Matchers.startsWith((String)"multipart/form-data"));
                Assert.assertThat((Object)contentType, (Matcher)Matchers.containsString((String)boundaryPart));
            }
        }
    }

    private String getUri(String path) {
        return String.format("http://localhost:%s%s", this.port.getValue(), path);
    }

    private Collection<HttpPart> createPart() {
        HttpPart part = new HttpPart(TEXT_BODY_FIELD_NAME, TEXT_BODY_FIELD_VALUE.getBytes(), "text/plain", TEXT_BODY_FIELD_VALUE.length());
        return Collections.singletonList(part);
    }

    private HttpEntity getMultipartEntity() {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody(TEXT_BODY_FIELD_NAME, TEXT_BODY_FIELD_VALUE, ContentType.TEXT_PLAIN);
        return builder.build();
    }
}

