/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.utils.UriCache;
import org.mule.service.http.impl.service.server.NoListenerRequestHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class NoListenerRequestHandlerTestCase
extends AbstractMuleTestCase {
    private static final String TEST_REQUEST_INVALID_URI = "http://localhost:8081/<script>alert('hello');</script>";
    private final HttpRequestContext context = (HttpRequestContext)Mockito.mock(HttpRequestContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final HttpResponseReadyCallback responseReadyCallback = (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class);
    private NoListenerRequestHandler noListenerRequestHandler;

    @Before
    public void setUp() throws Exception {
        this.noListenerRequestHandler = NoListenerRequestHandler.getInstance();
        Mockito.when((Object)this.context.getRequest().getUri()).then(obj -> UriCache.getUriFromString((String)TEST_REQUEST_INVALID_URI));
    }

    @Test
    public void testInvalidEndpointWithSpecialCharacters() throws Exception {
        String[] result = new String[1];
        ((HttpResponseReadyCallback)Mockito.doAnswer(invocation -> {
            HttpResponse response = (HttpResponse)invocation.getArguments()[0];
            InputStreamHttpEntity inputStreamHttpEntity = (InputStreamHttpEntity)response.getEntity();
            result[0] = IOUtils.toString((InputStream)inputStreamHttpEntity.getContent());
            inputStreamHttpEntity.getContent().close();
            return null;
        }).when((Object)this.responseReadyCallback)).responseReady((HttpResponse)Matchers.any(HttpResponse.class), (ResponseStatusCallback)Matchers.any(ResponseStatusCallback.class));
        this.noListenerRequestHandler.handleRequest(this.context, this.responseReadyCallback);
        Assert.assertThat((Object)result[0], (Matcher)org.hamcrest.Matchers.not((Object)Matchers.contains((String)"<script>alert('hello');</script>")));
    }
}

