/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import com.ning.http.client.Response;
import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.service.domain.entity.multipart.StreamedMultipartHttpEntity;

public class HttpResponseCreator {
    public HttpResponse create(Response response, InputStream inputStream) throws IOException {
        HttpResponseBuilder responseBuilder = HttpResponse.builder();
        responseBuilder.statusCode(Integer.valueOf(response.getStatusCode()));
        responseBuilder.reasonPhrase(response.getStatusText());
        String contentType = response.getHeader("Content-Type".toLowerCase());
        String contentLength = response.getHeader("Content-Length".toLowerCase());
        responseBuilder.entity(this.createEntity(inputStream, contentType, contentLength));
        if (response.hasResponseHeaders()) {
            for (String header : response.getHeaders().keySet()) {
                for (String headerValue : response.getHeaders(header)) {
                    responseBuilder.addHeader(header, headerValue);
                }
            }
        }
        return responseBuilder.build();
    }

    private HttpEntity createEntity(InputStream stream, String contentType, String contentLength) {
        Long contentLengthAsLong = -1L;
        if (contentLength != null) {
            contentLengthAsLong = Long.parseLong(contentLength);
        }
        if (contentType != null && contentType.startsWith(MediaType.MULTIPART_MIXED.getPrimaryType())) {
            if (contentLengthAsLong >= 0L) {
                return new StreamedMultipartHttpEntity(stream, contentType, contentLengthAsLong);
            }
            return new StreamedMultipartHttpEntity(stream, contentType);
        }
        if (contentLengthAsLong > 0L) {
            return new InputStreamHttpEntity(stream, contentLengthAsLong);
        }
        if (contentLengthAsLong == 0L) {
            return new EmptyHttpEntity();
        }
        return new InputStreamHttpEntity(stream);
    }
}

