/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.util.Optional;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResponseCompletionHandler
extends EmptyCompletionHandler<WriteResult> {
    protected boolean hasContentLength = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseResponseCompletionHandler.class);
    private static final String MULTIPART_CONTENT_TYPE_FORMAT = "%s; %s=\"%s\"";

    protected HttpResponsePacket buildHttpResponsePacket(HttpRequestPacket sourceRequest, HttpResponse httpResponse) {
        HttpResponsePacket.Builder responsePacketBuilder = HttpResponsePacket.builder((HttpRequestPacket)sourceRequest).status(httpResponse.getStatusCode()).reasonPhrase(httpResponse.getReasonPhrase());
        String contentType = null;
        boolean hasTransferEncoding = false;
        boolean hasConnection = false;
        for (String headerName : httpResponse.getHeaderNames()) {
            if (contentType == null && headerName.equalsIgnoreCase("Content-Type")) {
                contentType = httpResponse.getHeaderValue(headerName);
            }
            if (!hasTransferEncoding && headerName.equalsIgnoreCase("Transfer-Encoding")) {
                hasTransferEncoding = true;
            }
            if (!hasConnection && headerName.equalsIgnoreCase("Connection")) {
                hasConnection = true;
            }
            if (!this.hasContentLength && headerName.equalsIgnoreCase("Content-Length")) {
                this.hasContentLength = true;
            }
            for (String value : httpResponse.getHeaderValues(headerName)) {
                responsePacketBuilder.header(headerName, value);
            }
        }
        if (httpResponse.getEntity().isComposed()) {
            if (contentType == null) {
                responsePacketBuilder.header("Content-Type", String.format(MULTIPART_CONTENT_TYPE_FORMAT, "multipart/form-data", "boundary", UUID.getUUID()));
            } else if (!contentType.contains("boundary")) {
                responsePacketBuilder.removeHeader("Content-Type");
                responsePacketBuilder.header("Content-Type", String.format(MULTIPART_CONTENT_TYPE_FORMAT, contentType, "boundary", UUID.getUUID()));
            }
        }
        Optional length = httpResponse.getEntity().getLength();
        Protocol protocol = sourceRequest.getProtocol();
        if (!hasTransferEncoding && !this.hasContentLength && length.isPresent() && !protocol.equals((Object)Protocol.HTTP_1_0)) {
            responsePacketBuilder.header("Content-Length", String.valueOf(length.get()));
        }
        HttpResponsePacket httpResponsePacket = responsePacketBuilder.build();
        httpResponsePacket.setProtocol(protocol);
        if (hasTransferEncoding) {
            httpResponsePacket.setChunked(true);
        }
        if (hasConnection) {
            httpResponsePacket.getProcessingState().setKeepAlive(false);
        }
        return httpResponsePacket;
    }

    public void cancelled() {
        LOGGER.warn("HTTP response sending task was cancelled");
    }

    public void failed(Throwable throwable) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(String.format("HTTP response sending task failed with error: %s", throwable.getMessage()));
        }
    }
}

