/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import io.qameta.allure.Story;
import java.io.InputStream;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;

@Story(value="Multipart")
public class HttpPartDispositionTestCase
extends AbstractHttpClientTestCase {
    private static final String BOUNDARY = "bec89590-35fe-11e5-a966-de100cec9c0d";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition: form-data; name=\"partName\"\r\n";
    private static final String MULTIPART_FORMAT = "--%1$s\r\n %2$sContent-Type: text/plain\n\r\ntest\r\n--%1$s--\r\n";
    private static final String CONTENT_DISPOSITION_PARAM = "contentDisposition";
    private HttpClient client;

    public HttpPartDispositionTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void createClient() {
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("multipart-test").build());
        this.client.start();
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder response = HttpResponse.builder();
        String contentDispositionHeader = Boolean.TRUE.toString().equals(request.getQueryParams().get((Object)CONTENT_DISPOSITION_PARAM)) ? CONTENT_DISPOSITION_HEADER : "";
        byte[] body = String.format(MULTIPART_FORMAT, BOUNDARY, contentDispositionHeader).getBytes();
        response.addHeader("Content-Type", String.format("multipart/form-data; boundary=%s", BOUNDARY));
        response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode()));
        response.entity((HttpEntity)new ByteArrayHttpEntity(body));
        return response.build();
    }

    @After
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void receivesMultipartContentWithContentDisposition() throws Exception {
        this.testWithContentDisposition(Boolean.TRUE);
    }

    @Test
    public void receivesMultipartContentWithoutContentDisposition() throws Exception {
        this.testWithContentDisposition(Boolean.FALSE);
    }

    private void testWithContentDisposition(Boolean addHeader) throws Exception {
        MultiMap queryParams = new MultiMap();
        queryParams.put((Object)CONTENT_DISPOSITION_PARAM, (Object)addHeader.toString());
        HttpResponse response = this.client.send(HttpRequest.builder().uri(this.getUri()).queryParams(queryParams).build(), 10000, true, null);
        Assert.assertThat((Object)response.getEntity().isComposed(), (Matcher)Matchers.is((Object)true));
        Collection parts = response.getEntity().getParts();
        Assert.assertThat((Object)parts, (Matcher)Matchers.hasSize((int)1));
        HttpPart part = (HttpPart)parts.iterator().next();
        Assert.assertThat((Object)part.getContentType(), (Matcher)Matchers.is((Object)MediaType.TEXT.toRfcString()));
        Assert.assertThat((Object)IOUtils.toString((InputStream)part.getInputStream()), (Matcher)Matchers.is((Object)"test"));
        if (addHeader.booleanValue()) {
            Assert.assertThat((Object)part.getName(), (Matcher)Matchers.is((Object)"partName"));
        }
    }
}

