/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.providers.grizzly.GrizzlyResponseBodyPart;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.util.concurrent.CompletableFuture;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.HttpContent;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.util.Reference;
import org.mule.service.http.impl.service.client.async.ResponseBodyDeferringAsyncHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@Feature(value="HTTP Service")
@Story(value="Streaming")
public class ResponseBodyDeferringAsyncHandlerTestCase
extends AbstractMuleTestCase {
    private static final int PROBE_TIMEOUT = 5000;
    private static final int POLL_DELAY = 300;
    private static final int BUFFER_SIZE = 1024;

    @Test
    public void doesNotStreamWhenPossible() throws Exception {
        CompletableFuture future = new CompletableFuture();
        final Reference responseContent = new Reference();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, 1024);
        handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        GrizzlyResponseBodyPart bodyPart = (GrizzlyResponseBodyPart)Mockito.mock(GrizzlyResponseBodyPart.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)bodyPart.isLast()).thenReturn((Object)true);
        future.whenComplete((response, exception) -> {
            InputStream cfr_ignored_0 = (InputStream)responseContent.set((Object)response.getEntity().getContent());
        });
        Assert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)bodyPart), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
        new PollingProber(5000L, 300L).check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                Assert.assertThat((Object)responseContent.get(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
                Assert.assertThat((Object)responseContent.get(), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(PipedInputStream.class)));
                return true;
            }
        });
    }

    @Test
    public void streamsWhenRequired() throws Exception {
        CompletableFuture future = new CompletableFuture();
        final Reference responseContent = new Reference();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, 1024);
        handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        GrizzlyResponseBodyPart bodyPart = (GrizzlyResponseBodyPart)Mockito.mock(GrizzlyResponseBodyPart.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)bodyPart.isLast()).thenReturn((Object)false);
        future.whenComplete((response, exception) -> {
            InputStream cfr_ignored_0 = (InputStream)responseContent.set((Object)response.getEntity().getContent());
        });
        Assert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)bodyPart), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
        new PollingProber(5000L, 300L).check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                Assert.assertThat((Object)responseContent.get(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
                Assert.assertThat((Object)responseContent.get(), (Matcher)Matchers.instanceOf(PipedInputStream.class));
                return true;
            }
        });
    }

    @Test
    public void abortsWhenPipeIsClosed() throws Exception {
        CompletableFuture future = new CompletableFuture();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, 1024);
        handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        GrizzlyResponseBodyPart bodyPart = (GrizzlyResponseBodyPart)Mockito.spy((Object)new GrizzlyResponseBodyPart((HttpContent)Mockito.mock(HttpContent.class), (Connection)Mockito.mock(Connection.class)));
        Mockito.when((Object)bodyPart.isLast()).thenReturn((Object)false);
        ((GrizzlyResponseBodyPart)Mockito.doReturn((Object)"You will call me Snowball because my fur is pretty and white.".getBytes()).when((Object)bodyPart)).getBodyPartBytes();
        handler.onBodyPartReceived((HttpResponseBodyPart)bodyPart);
        handler.closeOut();
        Assert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)bodyPart), (Matcher)Matchers.is((Object)AsyncHandler.STATE.ABORT));
    }
}

