/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;

public class HttpClientMaxConnectionsTestCase
extends AbstractHttpClientTestCase {
    private static final String ERROR_MESSAGE = "Connection limit exceeded, cannot process request";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private Latch handling = new Latch();
    private Latch complete = new Latch();
    private HttpClient client;

    public HttpClientMaxConnectionsTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void createClient() throws CreateException {
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setMaxConnections(1).setName("max-connections-test").build());
        this.client.start();
    }

    @After
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        this.handling.release();
        try {
            this.complete.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return HttpResponse.builder().build();
    }

    @Test
    public void failsOnConnectionsExceededWhenSync() throws Exception {
        try {
            this.client.sendAsync(this.getRequest(), 10000, true, null);
            this.handling.await();
            this.expectedException.expect(IOException.class);
            this.expectedException.expectMessage(ERROR_MESSAGE);
            this.client.send(this.getRequest(), 1, true, null);
        }
        finally {
            this.complete.release();
        }
    }

    @Test
    public void failsOnConnectionsExceededWhenAsync() throws Exception {
        try {
            this.client.sendAsync(this.getRequest(), 10000, true, null);
            this.handling.await();
            this.expectedException.expect(ExecutionException.class);
            this.expectedException.expectCause(Matchers.instanceOf(IOException.class));
            this.expectedException.expectMessage(ERROR_MESSAGE);
            this.client.sendAsync(this.getRequest(), 1, true, null).get();
        }
        finally {
            this.complete.release();
        }
    }

    private HttpRequest getRequest() {
        return HttpRequest.builder().uri(this.getUri()).build();
    }
}

