/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.apache.http.Header;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@Story(value="Transfer Type")
public abstract class HttpServerTransferTestCase
extends AbstractHttpServiceTestCase {
    protected static final String DATA = "My awesome data";
    protected static final String MULTIPART_DATA = "--bounds\r\nContent-Type: text/plain\r\nContent-Disposition: form-data; name=\"name\"\r\n\r\nMy awesome data\r\n--bounds--\r\n";
    protected static final byte[] DATA_BYTES = "My awesome data".getBytes();
    protected static final String DATA_SIZE = String.valueOf(DATA_BYTES.length);
    protected static final String MULTIPART_SIZE = "112";
    protected static final Pair<String, String> CHUNKED_PAIR = new Pair((Object)"Transfer-Encoding", (Object)"chunked");
    protected static final String STREAM = "/stream";
    protected static final String BYTES = "/bytes";
    protected static final String MULTIPART = "/multipart";
    @Rule
    public DynamicPort port = new DynamicPort("port");
    private HttpServer server;
    protected Pair<String, String> headerToSend;

    public HttpServerTransferTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setUp() throws Exception {
        this.server = this.service.getServerFactory().create(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.getNumber()).setName("transfer-test").build());
        this.server.start();
        AbstractHttpServiceTestCase.IgnoreResponseStatusCallback statusCallback = new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback();
        this.server.addRequestHandler("/", (requestContext, responseCallback) -> responseCallback.responseReady(this.getResponse().build(), statusCallback));
        this.server.addRequestHandler(STREAM, (requestContext, responseCallback) -> {
            InputStreamHttpEntity entity = new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(DATA_BYTES));
            responseCallback.responseReady(((HttpResponseBuilder)this.getResponse().entity((HttpEntity)entity)).build(), statusCallback);
        });
        this.server.addRequestHandler(BYTES, (requestContext, responseCallback) -> {
            ByteArrayHttpEntity entity = new ByteArrayHttpEntity(DATA_BYTES);
            responseCallback.responseReady(((HttpResponseBuilder)this.getResponse().entity((HttpEntity)entity)).build(), statusCallback);
        });
        this.server.addRequestHandler(MULTIPART, (requestContext, responseCallback) -> {
            HttpPart part = new HttpPart("name", DATA_BYTES, "text/plain", DATA_BYTES.length);
            MultipartHttpEntity entity = new MultipartHttpEntity(Collections.singletonList(part));
            responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)this.getResponse().entity((HttpEntity)entity)).addHeader("Content-Type", "multipart/form-data; boundary=\"bounds\"")).build(), statusCallback);
        });
    }

    private HttpResponseBuilder getResponse() {
        HttpResponseBuilder responseBuilder = HttpResponse.builder();
        if (this.headerToSend != null) {
            responseBuilder.addHeader((String)this.headerToSend.getFirst(), (String)this.headerToSend.getSecond());
        }
        return responseBuilder;
    }

    @After
    public void tearDown() {
        if (this.server != null) {
            this.server.stop();
            this.server.dispose();
        }
    }

    public abstract HttpVersion getVersion();

    @Test
    public void usesLengthWhenEmptyAndHeader() throws Exception {
        this.headerToSend = new Pair((Object)"Content-Length", (Object)"0");
        this.verifyTransferHeaders("", (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), (Matcher<Object>)Matchers.is((Object)"0"), "");
    }

    @Test
    public void usesLengthWhenBytesAndHeader() throws Exception {
        this.headerToSend = new Pair((Object)"Content-Length", (Object)DATA_SIZE);
        this.verifyTransferHeaders(BYTES, (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), (Matcher<Object>)Matchers.is((Object)DATA_SIZE), DATA);
    }

    @Test
    public void usesLengthWhenMultipartAndHeader() throws Exception {
        this.headerToSend = new Pair((Object)"Content-Length", (Object)MULTIPART_SIZE);
        this.verifyTransferHeaders(MULTIPART, (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), (Matcher<Object>)Matchers.is((Object)MULTIPART_SIZE), MULTIPART_DATA);
    }

    @Test
    public void usesLengthWhenStreamAndHeader() throws Exception {
        this.headerToSend = new Pair((Object)"Content-Length", (Object)DATA_SIZE);
        this.verifyTransferHeaders(STREAM, (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), (Matcher<Object>)Matchers.is((Object)DATA_SIZE), DATA);
    }

    protected void verifyTransferHeaders(String path, Matcher<Object> transferEncodingMatcher, Matcher<Object> contentLengthMatcher, String expectedBody) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(this.getUri(path));
            httpGet.setProtocolVersion((ProtocolVersion)this.getVersion());
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                Assert.assertThat((Object)this.getHeaderValue(response, "Transfer-Encoding"), transferEncodingMatcher);
                Assert.assertThat((Object)this.getHeaderValue(response, "Content-Length"), contentLengthMatcher);
                Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Object)expectedBody));
            }
        }
    }

    protected String getHeaderValue(CloseableHttpResponse response, String name) {
        Header header = response.getFirstHeader(name);
        return header != null ? header.getValue() : null;
    }

    protected String getUri(String path) {
        return "http://localhost:" + this.port.getValue() + path;
    }
}

