/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventLifeCycleListener;
import org.glassfish.grizzly.strategies.AbstractIOStrategy;
import org.mule.service.http.impl.service.server.DefaultServerAddress;
import org.mule.service.http.impl.service.server.grizzly.ExecutorProvider;

public class ExecutorPerServerAddressIOStrategy
extends AbstractIOStrategy {
    private static final EnumSet<IOEvent> WORKER_THREAD_EVENT_SET = EnumSet.of(IOEvent.READ, IOEvent.CLOSED);
    private static final Logger logger = Grizzly.logger(ExecutorPerServerAddressIOStrategy.class);
    private final ExecutorProvider executorProvider;

    public ExecutorPerServerAddressIOStrategy(ExecutorProvider executorProvider) {
        this.executorProvider = executorProvider;
    }

    public boolean executeIoEvent(Connection connection, IOEvent ioEvent, boolean isIoEventEnabled) throws IOException {
        IOEventLifeCycleListener listener;
        boolean isReadOrWriteEvent = ExecutorPerServerAddressIOStrategy.isReadWrite((IOEvent)ioEvent);
        if (isReadOrWriteEvent) {
            if (isIoEventEnabled) {
                connection.disableIOEvent(ioEvent);
            }
            listener = ENABLE_INTEREST_LIFECYCLE_LISTENER;
        } else {
            listener = null;
        }
        Executor threadPool = this.getThreadPoolFor(connection, ioEvent);
        if (threadPool != null) {
            threadPool.execute(new WorkerThreadRunnable(connection, ioEvent, listener));
        } else {
            ExecutorPerServerAddressIOStrategy.run0(connection, ioEvent, listener);
        }
        return true;
    }

    public Executor getThreadPoolFor(Connection connection, IOEvent ioEvent) {
        if (WORKER_THREAD_EVENT_SET.contains(ioEvent)) {
            String ip = ((InetSocketAddress)connection.getLocalAddress()).getAddress().getHostAddress();
            int port = ((InetSocketAddress)connection.getLocalAddress()).getPort();
            return this.executorProvider.getExecutor(new DefaultServerAddress(ip, port));
        }
        return null;
    }

    private static void run0(Connection connection, IOEvent ioEvent, IOEventLifeCycleListener lifeCycleListener) {
        ExecutorPerServerAddressIOStrategy.fireIOEvent((Connection)connection, (IOEvent)ioEvent, (IOEventLifeCycleListener)lifeCycleListener, (Logger)logger);
    }

    private static final class WorkerThreadRunnable
    implements Runnable {
        final Connection connection;
        final IOEvent ioEvent;
        final IOEventLifeCycleListener lifeCycleListener;

        private WorkerThreadRunnable(Connection connection, IOEvent ioEvent, IOEventLifeCycleListener lifeCycleListener) {
            this.connection = connection;
            this.ioEvent = ioEvent;
            this.lifeCycleListener = lifeCycleListener;
        }

        @Override
        public void run() {
            ExecutorPerServerAddressIOStrategy.run0(this.connection, this.ioEvent, this.lifeCycleListener);
        }
    }
}

