/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional;

import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;
import org.mule.service.http.impl.service.domain.entity.multipart.StreamedMultipartHttpEntity;
import org.mule.tck.junit4.matcher.IsEmptyOptional;

@Story(value="Transfer Type")
public class HttpTransferLengthTestCase
extends AbstractHttpClientTestCase {
    private static final String RESPONSE = "TEST";
    private static final String REQUEST = "tests";
    private static final String BYTE = "/byte";
    private static final String MULTIPART = "/multipart";
    private static final String STREAM = "/stream";
    private static final String CHUNKED = "/chunked";
    private HttpClient client;

    public HttpTransferLengthTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void createClient() {
        HttpClientConfiguration clientConf = new HttpClientConfiguration.Builder().setName("transfer-type-test").build();
        this.client = this.service.getClientFactory().create(clientConf);
        this.client.start();
    }

    @After
    public void closeClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        String path = request.getPath();
        HttpEntity entity = request.getEntity();
        HttpResponseBuilder builder = HttpResponse.builder();
        try {
            Optional<Long> expectedRequestLength = Optional.of(Long.valueOf(REQUEST.length()));
            if (BYTE.equals(path)) {
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(InputStreamHttpEntity.class)));
                builder.entity((HttpEntity)new ByteArrayHttpEntity(RESPONSE.getBytes()));
            } else if (MULTIPART.equals(path)) {
                expectedRequestLength = Optional.of(142L);
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StreamedMultipartHttpEntity.class)));
                HttpPart part = new HttpPart("part1", RESPONSE.getBytes(), "text/plain", 4);
                ((HttpResponseBuilder)builder.entity((HttpEntity)new MultipartHttpEntity(Collections.singletonList(part)))).addHeader("Content-Type", "multipart/form-data; boundary=\"bounds\"");
            } else if (STREAM.equals(path)) {
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(InputStreamHttpEntity.class)));
                builder.entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(RESPONSE.getBytes()), Long.valueOf(4L)));
            } else if (CHUNKED.equals(path)) {
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(InputStreamHttpEntity.class)));
                expectedRequestLength = Optional.empty();
                builder.entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(RESPONSE.getBytes())));
            } else {
                expectedRequestLength = Optional.of(0L);
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(EmptyHttpEntity.class)));
            }
            Assert.assertThat((Object)request.getEntity().getLength(), (Matcher)Matchers.is(expectedRequestLength));
            return builder.build();
        }
        catch (AssertionError e) {
            return ((HttpResponseBuilder)builder.statusCode(Integer.valueOf(500)).entity((HttpEntity)new ByteArrayHttpEntity(((Throwable)((Object)e)).getMessage().getBytes()))).build();
        }
    }

    @Test
    public void propagatesLengthWhenByte() throws Exception {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(this.getUri() + BYTE).entity((HttpEntity)new ByteArrayHttpEntity(REQUEST.getBytes()))).build();
        HttpResponse response = this.send(request);
        Assert.assertThat(response.getEntity().getLength().get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)4L)));
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(InputStreamHttpEntity.class));
    }

    @Test
    public void propagatesLengthWhenMultipart() throws Exception {
        HttpPart part = new HttpPart("part1", REQUEST.getBytes(), "text/plain", 5);
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(this.getUri() + MULTIPART).addHeader("Content-Type", "multipart/form-data; boundary=\"bounds\"")).entity((HttpEntity)new MultipartHttpEntity(Collections.singletonList(part)))).build();
        HttpResponse response = this.send(request);
        Assert.assertThat(response.getEntity().getLength().get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)102L)));
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(StreamedMultipartHttpEntity.class));
    }

    @Test
    public void propagatesLengthWhenEmpty() throws Exception {
        HttpRequest request = HttpRequest.builder().uri(this.getUri() + "/empty").build();
        HttpResponse response = this.send(request);
        Assert.assertThat(response.getEntity().getLength().get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(EmptyHttpEntity.class));
    }

    @Test
    public void propagatesLengthWhenStream() throws Exception {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(this.getUri() + STREAM).entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(REQUEST.getBytes()), Long.valueOf(5L)))).build();
        HttpResponse response = this.send(request);
        Assert.assertThat(response.getEntity().getLength().get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)4L)));
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(InputStreamHttpEntity.class));
    }

    @Test
    public void doesNotPropagateLengthWhenChunked() throws Exception {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(this.getUri() + CHUNKED).entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(REQUEST.getBytes())))).build();
        HttpResponse response = this.send(request);
        Assert.assertThat((Object)response.getEntity().getLength(), (Matcher)Matchers.is((Matcher)IsEmptyOptional.empty()));
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(InputStreamHttpEntity.class));
    }

    private HttpResponse send(HttpRequest request) throws Exception {
        HttpResponse response = this.client.send(request, 10000, false, null);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        return response;
    }
}

