/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPOutputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;
import org.mule.service.http.impl.service.client.GrizzlyHttpClient;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpClientPropertyDecompressionTestCase
extends AbstractHttpClientTestCase {
    @Rule
    public SystemProperty decompressionProperty = new SystemProperty("mule.http.client.decompress", "true");
    private static final String TEST_MESSAGE = "This is a regular message.";
    private HttpClient client;
    private byte[] compressedData;

    public HttpClientPropertyDecompressionTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void createClient() throws IOException {
        GrizzlyHttpClient.refreshSystemProperties();
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("decompression-property-test").build());
        this.client.start();
        this.compressedData = this.getCompressedData().toByteArray();
    }

    @After
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
        GrizzlyHttpClient.refreshSystemProperties();
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder builder = (HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new ByteArrayHttpEntity(this.compressedData));
        if (request.getHeaderValue("Accept-Encoding") != null) {
            builder.addHeader("Content-Encoding", "gzip");
        }
        return builder.build();
    }

    @Test
    public void decompressesResponseWhenIndicated() throws IOException, TimeoutException {
        this.validateResponse((HttpRequestBuilder)HttpRequest.builder().addHeader("Accept-Encoding", "gzip"), TEST_MESSAGE.getBytes());
    }

    @Test
    public void doesNotDecompressDataWithoutIndication() throws IOException, TimeoutException {
        this.validateResponse(HttpRequest.builder(), this.compressedData);
    }

    private void validateResponse(HttpRequestBuilder builder, byte[] expectedResponse) throws IOException, TimeoutException {
        HttpResponse response = this.client.send(builder.uri(this.getUri()).build(), 30000, true, null);
        Assert.assertThat((Object)response.getEntity().getBytes(), (Matcher)Matchers.is((Object)expectedResponse));
    }

    private ByteArrayOutputStream getCompressedData() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gzipOutputStream.write(TEST_MESSAGE.getBytes());
        gzipOutputStream.flush();
        gzipOutputStream.close();
        return byteArrayOutputStream;
    }
}

