/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpServerTimeoutTestCase
extends AbstractHttpServiceTestCase {
    private static int SERVER_TIMEOUT_MILLIS = 500;
    private static int CONNECTION_TIMEOUT_MILLIS = 2000;
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public DynamicPort port2 = new DynamicPort("port2");
    @Rule
    public DynamicPort port3 = new DynamicPort("port3");
    @Rule
    public SystemProperty serverTimeout = new SystemProperty("mule.http.server.timeout", String.valueOf(SERVER_TIMEOUT_MILLIS));
    private HttpServer server1;
    private HttpServer server2;
    private HttpServer server3;

    public HttpServerTimeoutTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setUp() throws Exception {
        this.server1 = this.buildServer(this.getServerBuilder(this.port1, "server-timeout-test").setUsePersistentConnections(false));
        this.server2 = this.buildServer(this.getServerBuilder(this.port2, "server-connection-timeout-test").setConnectionIdleTimeout(CONNECTION_TIMEOUT_MILLIS));
        this.server3 = this.buildServer(this.getServerBuilder(this.port3, "server-no-timeout-test").setConnectionIdleTimeout(-1));
    }

    @After
    public void tearDown() {
        this.close(this.server1);
        this.close(this.server2);
        this.close(this.server3);
    }

    private HttpServer buildServer(HttpServerConfiguration.Builder serverBuilder) throws ServerCreationException, IOException {
        HttpServer httpServer = this.service.getServerFactory().create(serverBuilder.build());
        httpServer.start();
        httpServer.addRequestHandler(Collections.singletonList(HttpConstants.Method.GET.name()), "/test", (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new ByteArrayHttpEntity("Success!".getBytes()))).addHeader("Content-Type", MediaType.TEXT.toRfcString())).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback()));
        return httpServer;
    }

    private HttpServerConfiguration.Builder getServerBuilder(DynamicPort port, String name) {
        return new HttpServerConfiguration.Builder().setHost("localhost").setPort(port.getNumber()).setName(name);
    }

    private void close(HttpServer server) {
        if (server != null) {
            server.stop();
            server.dispose();
        }
    }

    @Test
    public void serverTimeoutsTcpConnection() throws Exception {
        Socket socket = new Socket("localhost", this.port1.getNumber());
        Thread.sleep(SERVER_TIMEOUT_MILLIS * 2);
        this.sendRequest(socket);
        Assert.assertThat((Object)this.getResponse(socket), (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void keepAlivePreventsServerTimeout() throws Exception {
        Socket socket = new Socket("localhost", this.port2.getNumber());
        this.sendRequest(socket);
        Assert.assertThat((Object)this.getResponse(socket), (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        Thread.sleep(SERVER_TIMEOUT_MILLIS * 2);
        this.sendRequest(socket);
        Assert.assertThat((Object)this.getResponse(socket), (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        Thread.sleep(CONNECTION_TIMEOUT_MILLIS + SERVER_TIMEOUT_MILLIS * 2);
        this.sendRequest(socket);
        Assert.assertThat((Object)this.getResponse(socket), (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void infiniteKeepAlivePreventsServerTimeout() throws Exception {
        Socket socket = new Socket("localhost", this.port3.getNumber());
        this.sendRequest(socket);
        Assert.assertThat((Object)this.getResponse(socket), (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
        Thread.sleep(SERVER_TIMEOUT_MILLIS * 3);
        this.sendRequest(socket);
        Assert.assertThat((Object)this.getResponse(socket), (Matcher)Matchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    private void sendRequest(Socket socket) throws IOException {
        PrintWriter writer = new PrintWriter(socket.getOutputStream());
        writer.println("GET /test HTTP/1.1");
        writer.println("Host: www.example.com");
        writer.println("");
        writer.flush();
    }

    private String getResponse(Socket socket) {
        try {
            String response;
            StringWriter writer = new StringWriter();
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            if (reader != null) {
                String line;
                while (!StringUtils.isEmpty((String)(line = reader.readLine()))) {
                    writer.append(line).append("\r\n");
                }
            }
            return (response = writer.toString()).length() == 0 ? null : response;
        }
        catch (IOException e) {
            return null;
        }
    }
}

