/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.fluent.Request;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringContains;
import org.hamcrest.core.StringEndsWith;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.service.http.impl.service.util.SocketRequester;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpServiceMalformedUrlTestCase
extends AbstractHttpServiceTestCase {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String MALFORMED = "/api/ping%";
    private static final String WILDCARD = "*";
    private static final String MALFORMED_SCRIPT = "<script></script>%";
    private static final String ENCODED_SPACE = "test/foo 1 %";
    private static final String ENCODED_HASHTAG = "test/foo 1 #";
    private static final String ENCODED_PERCENT2 = "test/%24";
    private static final String TEST_PAYLOAD1 = "test-payload1";
    private static final String TEST_PAYLOAD2 = "test-payload2";
    private static final String TEST_PAYLOAD3 = "test-payload3";
    @Rule
    public DynamicPort port = new DynamicPort("port");
    protected HttpServer server;

    public HttpServiceMalformedUrlTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    protected String getServerName() {
        return "malformedurl-test";
    }

    @Before
    public void setUp() throws Exception {
        this.setUpServer();
        this.registerHandler(HttpConstants.Method.GET, WILDCARD, "Success!");
        this.registerHandler(HttpConstants.Method.POST, ENCODED_SPACE, TEST_PAYLOAD1);
        this.registerHandler(HttpConstants.Method.POST, ENCODED_HASHTAG, TEST_PAYLOAD2);
        this.registerHandler(HttpConstants.Method.POST, ENCODED_PERCENT2, TEST_PAYLOAD3);
    }

    private void registerHandler(HttpConstants.Method httpMethod, String endpoint, String payload) {
        this.server.addRequestHandler(Collections.singletonList(httpMethod.name()), "/" + endpoint, (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)org.mule.runtime.http.api.domain.message.response.HttpResponse.builder().entity((HttpEntity)new ByteArrayHttpEntity(payload.getBytes()))).addHeader("Content-Type", MediaType.TEXT.toRfcString())).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback()));
    }

    protected HttpServerConfiguration.Builder configureServer(HttpServerConfiguration.Builder builder) {
        return builder;
    }

    protected void setUpServer() throws Exception {
        this.server = this.service.getServerFactory().create(this.configureServer(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.getNumber()).setName(this.getServerName())).build());
        this.server.start();
    }

    @Test
    public void returnsBadRequestOnMalformedUrlForWildcardEndpoint() throws Exception {
        SocketRequester socketRequester = new SocketRequester(this.server.getServerAddress().getIp(), this.port.getNumber());
        try {
            socketRequester.initialize();
            socketRequester.doRequest("GET /api/ping% HTTP/1.1");
            String response = socketRequester.getResponse();
            Assert.assertThat((Object)response, (Matcher)StringContains.containsString((String)Integer.toString(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode())));
            Assert.assertThat((Object)response, (Matcher)StringContains.containsString((String)HttpConstants.HttpStatus.BAD_REQUEST.getReasonPhrase()));
            Assert.assertThat((Object)response, (Matcher)StringEndsWith.endsWith((String)("Unable to parse request: /api/ping%" + this.getRequestEnding())));
        }
        finally {
            socketRequester.finalizeGracefully();
        }
    }

    @Test
    public void returnsBadRequestOnMalformedUrlWithInvalidContentTypeWithScript() throws Exception {
        SocketRequester socketRequester = new SocketRequester(this.server.getServerAddress().getIp(), this.port.getNumber());
        try {
            socketRequester.initialize();
            socketRequester.doRequest("POST <script></script>% HTTP/1.1");
            String response = socketRequester.getResponse();
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)Integer.toString(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode())));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)HttpConstants.HttpStatus.BAD_REQUEST.getReasonPhrase()));
            Assert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)StringEscapeUtils.escapeHtml4((String)(MALFORMED_SCRIPT + this.getRequestEnding()))));
        }
        finally {
            socketRequester.finalizeGracefully();
        }
    }

    @Test
    public void returnsOKWithEndocodedPathForSpecificEndpointSpace() throws Exception {
        this.assertPostRequestGetsOKResponseStatusAndPayload(ENCODED_SPACE, TEST_PAYLOAD1);
    }

    @Test
    public void returnsOKWithEndocodedPathForSpecificEndpointHashtag() throws Exception {
        this.assertPostRequestGetsOKResponseStatusAndPayload(ENCODED_HASHTAG, TEST_PAYLOAD2);
    }

    @Test
    public void returnsOKWithEndocodedPathForSpecificEndpointPercent() throws Exception {
        this.assertPostRequestGetsOKResponseStatusAndPayload(ENCODED_PERCENT2, TEST_PAYLOAD3);
    }

    protected void assertPostRequestGetsOKResponseStatusAndPayload(String endpoint, String payload) throws IOException {
        Request request = Request.Post((String)this.getUrl(endpoint));
        HttpResponse response = request.execute().returnResponse();
        StatusLine statusLine = response.getStatusLine();
        Assert.assertThat((Object)statusLine.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Object)payload));
    }

    protected String getRequestEnding() {
        return LINE_SEPARATOR + "0" + LINE_SEPARATOR;
    }

    protected String getUrl(String path) throws UnsupportedEncodingException {
        return String.format("http://%s:%s/%s", this.server.getServerAddress().getIp(), this.port.getValue(), URLEncoder.encode(path, StandardCharsets.UTF_8.displayName()));
    }
}

