/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.service.http.impl.service.server.BadRequestHandler;
import org.mule.service.http.impl.service.server.DefaultServerAddress;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.NoListenerRequestHandler;
import org.mule.service.http.impl.service.server.NoMethodRequestHandler;
import org.mule.service.http.impl.service.server.grizzly.AcceptsAllMethodsRequestMatcher;
import org.mule.service.http.impl.service.server.grizzly.DefaultMethodRequestMatcher;
import org.mule.service.http.impl.service.server.grizzly.ListenerRequestMatcher;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@Feature(value="HTTP Service")
public class HttpListenerRegistryTestCase
extends AbstractMuleTestCase {
    public static final String TEST_IP = "127.0.0.1";
    public static final String URI_PARAM = "{uri-param}";
    public static final int TEST_PORT = 10000;
    public static final String ANOTHER_PATH = "/another-path";
    public static final String SOME_PATH = "some-path";
    public static final String SOME_OTHER_PATH = "some-other-path";
    private static final String MALFORMED = "/api/ping%";
    public static final String PATH_SEPARATOR = "/";
    public static final String ROOT_PATH = "/";
    public static final String FIRST_LEVEL_PATH_LOWER_CASE = "/first-level-path";
    public static final String FIRST_LEVEL_PATH_UPPER_CASE = "/FIRST_LEVEL_PATH";
    public static final String FIRST_LEVEL_PATH_UPPER_CASE_CATCH_ALL = "/FIRST_LEVEL_PATH/*";
    public static final String SECOND_LEVEL_PATH = "/first-level-path/second-level";
    public static final String FIRST_LEVEL_URI_PARAM = "/{uri-param}";
    public static final String FIRST_LEVEL_CATCH_ALL = "/*";
    public static final String SECOND_LEVEL_URI_PARAM = "/first-level-path/{uri-param}";
    public static final String SECOND_LEVEL_CATCH_ALL = "/first-level-path/*";
    public static final String FOURTH_LEVEL_CATCH_ALL = "/another-first-level-path/second-level-path/third-level-path/*";
    public static final String URI_PARAM_IN_THE_MIDDLE = "/first-level-path/{uri-param}/third-level-path";
    public static final String CATCH_ALL_IN_THE_MIDDLE = "/first-level-path/*/third-level-path";
    public static final String CATCH_ALL_IN_THE_MIDDLE_NO_COLLISION = "/another-first-level-path/*/third-level-path";
    public static final String SEVERAL_URI_PARAMS = "/{uri-param1}/second-level-path/{uri-param2}/fourth-level-path";
    public static final String SEVERAL_CATCH_ALL = "/*/second-level-path/*/fourth-level-path";
    public static final String METHOD_PATH_WILDCARD = "/method-path/*/";
    public static final String METHOD_PATH_URI_PARAM = "/another-method-path/{uri-param}/some-path";
    public static final String METHOD_PATH_CATCH_ALL = "/another-method-path/some-path/*";
    public static final String WILDCARD_CHARACTER = "*";
    public final RequestHandler methodPathWildcardGetRequestHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
    public final RequestHandler methodPathWildcardPostRequestHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
    public final RequestHandler methodPathUriParamGetRequestHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
    public final RequestHandler methodPathUriParamPostRequestHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
    public final RequestHandler methodPathCatchAllGetRequestHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
    public final RequestHandler methodPathCatchAllPostRequestHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
    private final ServerAddress testServerAddress = new DefaultServerAddress("127.0.0.1", 10000);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private RequestHandler mockRequestHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
    private Map<String, RequestHandler> requestHandlerPerPath = new HashMap<String, RequestHandler>();
    private HttpListenerRegistry httpListenerRegistry;
    private HttpServer testServer;

    @Before
    public void createMockTestServer() {
        this.testServer = (HttpServer)Mockito.mock(HttpServer.class);
        Mockito.when((Object)this.testServer.getServerAddress()).thenReturn((Object)this.testServerAddress);
    }

    @Test
    public void validateSimplePathAndAllMethodAllowedCollision() {
        HttpListenerRegistry httpListenerRegister = new HttpListenerRegistry();
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), ANOTHER_PATH));
        this.expectedException.expect(MuleRuntimeException.class);
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), ANOTHER_PATH));
    }

    @Test
    public void validateUriParamPathAndAllMethodAllowedCollision() {
        HttpListenerRegistry httpListenerRegister = new HttpListenerRegistry();
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), SECOND_LEVEL_URI_PARAM));
        this.expectedException.expect(MuleRuntimeException.class);
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), SECOND_LEVEL_URI_PARAM));
    }

    @Test
    public void validateCatchAllPathAndAllMethodAllowedCollision() {
        HttpListenerRegistry httpListenerRegister = new HttpListenerRegistry();
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), SECOND_LEVEL_CATCH_ALL));
        this.expectedException.expect(MuleRuntimeException.class);
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), SECOND_LEVEL_CATCH_ALL));
    }

    @Test
    public void validateCatchAllPathAndMethodAllowedCollision() {
        HttpListenerRegistry httpListenerRegister = new HttpListenerRegistry();
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.GET}), SECOND_LEVEL_CATCH_ALL));
        this.expectedException.expect(MuleRuntimeException.class);
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.GET}), SECOND_LEVEL_CATCH_ALL));
    }

    @Test
    public void validateCatchAllPathAndMethodIntersectionAllowedCollision() {
        HttpListenerRegistry httpListenerRegister = new HttpListenerRegistry();
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.GET, HttpConstants.Method.POST}), SECOND_LEVEL_CATCH_ALL));
        this.expectedException.expect(MuleRuntimeException.class);
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.PUT, HttpConstants.Method.POST}), SECOND_LEVEL_CATCH_ALL));
    }

    @Test
    public void validateRootPathCollision() {
        this.validateCollision("/", "/");
    }

    @Test
    public void validateFirstLevelPathCollision() {
        this.validateCollision(FIRST_LEVEL_PATH_LOWER_CASE, FIRST_LEVEL_PATH_LOWER_CASE);
    }

    @Test
    public void validateSecondLevelPathCollision() {
        this.validateCollision(SECOND_LEVEL_PATH, SECOND_LEVEL_PATH);
    }

    @Test
    public void validateNoCollisionWithSpecificAndCatchAll() {
        this.validateNoCollision(FIRST_LEVEL_CATCH_ALL, FIRST_LEVEL_PATH_LOWER_CASE);
    }

    @Test
    public void validateNoCollisionWithSpecificAndUriParameter() {
        this.validateNoCollision(FIRST_LEVEL_URI_PARAM, FIRST_LEVEL_PATH_LOWER_CASE);
    }

    @Test
    public void validateCollisionWithRootLevelCatchAllAndRootLevelCatchAll() {
        this.validateCollision(FIRST_LEVEL_CATCH_ALL, FIRST_LEVEL_CATCH_ALL);
    }

    @Test
    public void validateCollisionWithRootLevelUriParamAndRootLevelUriParam() {
        this.validateCollision(FIRST_LEVEL_URI_PARAM, FIRST_LEVEL_URI_PARAM);
    }

    @Test
    public void validateCollisionWithSecondLevelCatchAllAndSecondLevelCatchAll() {
        this.validateCollision(SECOND_LEVEL_CATCH_ALL, SECOND_LEVEL_CATCH_ALL);
    }

    @Test
    public void validateCollisionWithSecondLevelUriParamAndSecondLevelUriParam() {
        this.validateCollision(SECOND_LEVEL_URI_PARAM, SECOND_LEVEL_URI_PARAM);
    }

    @Test
    public void validateUriParamAndCatchAllInTheMiddle() {
        this.validateCollision(URI_PARAM_IN_THE_MIDDLE, CATCH_ALL_IN_THE_MIDDLE);
    }

    @Test
    public void validateUriParamAndUriParamInTheMiddle() {
        this.validateCollision(URI_PARAM_IN_THE_MIDDLE, URI_PARAM_IN_THE_MIDDLE);
    }

    @Test
    public void validateCatchAllAndUriParamInTheMiddle() {
        this.validateCollision(CATCH_ALL_IN_THE_MIDDLE, URI_PARAM_IN_THE_MIDDLE);
    }

    @Test
    public void validateCatchAllAndCatchAllInTheMiddle() {
        this.validateCollision(CATCH_ALL_IN_THE_MIDDLE, CATCH_ALL_IN_THE_MIDDLE);
    }

    @Test
    public void validateSeveralUriParamsAndSeveralUriParams() {
        this.validateCollision(SEVERAL_URI_PARAMS, SEVERAL_URI_PARAMS);
    }

    @Test
    public void validateSeveralUriParamsAndSeveralCatchAll() {
        this.validateCollision(SEVERAL_URI_PARAMS, SEVERAL_CATCH_ALL);
    }

    @Test
    public void validateSeveralCatchAllAndSeveralUriParams() {
        this.validateCollision(SEVERAL_CATCH_ALL, SEVERAL_URI_PARAMS);
    }

    @Test
    public void validateSeveralCatchAllAndSeveralCatchAll() {
        this.validateCollision(SEVERAL_CATCH_ALL, SEVERAL_CATCH_ALL);
    }

    @Test
    public void noCollisionWithCaseSensitivePaths() {
        this.validateNoCollision(FIRST_LEVEL_PATH_LOWER_CASE, FIRST_LEVEL_PATH_UPPER_CASE);
    }

    @Test
    public void routeToCorrectHandler() {
        this.httpListenerRegistry = this.createHttpListenerRegistryWithRegisteredHandlers();
        this.routePath("/", "/");
        this.routePath("/something", FIRST_LEVEL_CATCH_ALL);
        this.routePath("/something/else", FIRST_LEVEL_CATCH_ALL);
        this.routePath("/first-level-path/second-level/somethingElse", FIRST_LEVEL_CATCH_ALL);
        this.routePath("/first-level-path/second-levelsomethingElse", SECOND_LEVEL_URI_PARAM);
        this.routePath(FIRST_LEVEL_PATH_LOWER_CASE, FIRST_LEVEL_PATH_LOWER_CASE);
        this.routePath("/first-level-path/", FIRST_LEVEL_PATH_LOWER_CASE);
        this.routePath(FIRST_LEVEL_PATH_UPPER_CASE, FIRST_LEVEL_PATH_UPPER_CASE);
        this.routePath("/FIRST_LEVEL_PATH/", FIRST_LEVEL_PATH_UPPER_CASE);
        this.routePath("/FIRST_LEVEL_PATH/somethingElse", FIRST_LEVEL_PATH_UPPER_CASE_CATCH_ALL);
        this.routePath(SECOND_LEVEL_PATH, SECOND_LEVEL_PATH);
        this.routePath(SECOND_LEVEL_URI_PARAM.replace(URI_PARAM, "1"), SECOND_LEVEL_URI_PARAM);
        this.routePath(FOURTH_LEVEL_CATCH_ALL.replace(WILDCARD_CHARACTER, ""), FOURTH_LEVEL_CATCH_ALL);
        this.routePath(FOURTH_LEVEL_CATCH_ALL.replace(WILDCARD_CHARACTER, "foo1/foo2"), FOURTH_LEVEL_CATCH_ALL);
        this.routePath(URI_PARAM_IN_THE_MIDDLE.replace(URI_PARAM, "1"), URI_PARAM_IN_THE_MIDDLE);
        this.routePath(URI_PARAM_IN_THE_MIDDLE.replace(URI_PARAM, "1") + ANOTHER_PATH, FIRST_LEVEL_CATCH_ALL);
        this.routePath(CATCH_ALL_IN_THE_MIDDLE_NO_COLLISION.replace(WILDCARD_CHARACTER, SOME_PATH), CATCH_ALL_IN_THE_MIDDLE_NO_COLLISION);
        this.routePath(CATCH_ALL_IN_THE_MIDDLE_NO_COLLISION.replace(WILDCARD_CHARACTER, SOME_PATH) + ANOTHER_PATH, FIRST_LEVEL_CATCH_ALL);
        this.routePath(SEVERAL_CATCH_ALL.replace(WILDCARD_CHARACTER, SOME_PATH), SEVERAL_CATCH_ALL);
        this.routePath(SEVERAL_CATCH_ALL.replace(WILDCARD_CHARACTER, SOME_PATH) + ANOTHER_PATH, FIRST_LEVEL_CATCH_ALL);
        this.routePath(SEVERAL_CATCH_ALL.replace(WILDCARD_CHARACTER, SOME_PATH) + ANOTHER_PATH, FIRST_LEVEL_CATCH_ALL);
        this.routePath(METHOD_PATH_CATCH_ALL.replace(WILDCARD_CHARACTER, ANOTHER_PATH), HttpConstants.Method.GET, this.methodPathCatchAllGetRequestHandler);
        this.routePath(METHOD_PATH_CATCH_ALL.replace(WILDCARD_CHARACTER, ANOTHER_PATH), HttpConstants.Method.POST, this.methodPathCatchAllPostRequestHandler);
        this.routePath(METHOD_PATH_URI_PARAM.replace(URI_PARAM, SOME_OTHER_PATH), HttpConstants.Method.GET, this.methodPathUriParamGetRequestHandler);
        this.routePath(METHOD_PATH_URI_PARAM.replace(URI_PARAM, SOME_OTHER_PATH), HttpConstants.Method.POST, this.methodPathUriParamPostRequestHandler);
        this.routePath(METHOD_PATH_WILDCARD.replace(WILDCARD_CHARACTER, SOME_PATH), HttpConstants.Method.GET, this.methodPathWildcardGetRequestHandler);
        this.routePath(METHOD_PATH_WILDCARD.replace(WILDCARD_CHARACTER, SOME_PATH), HttpConstants.Method.POST, this.methodPathWildcardPostRequestHandler);
    }

    @Test
    public void noPathFound() {
        this.httpListenerRegistry = new HttpListenerRegistry();
        this.httpListenerRegistry.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), "/"));
        RequestHandler requestHandler = this.httpListenerRegistry.getRequestHandler((ServerAddress)new DefaultServerAddress(TEST_IP, 10000), this.createMockRequestWithPath(ANOTHER_PATH));
        Assert.assertThat((Object)requestHandler, (Matcher)Is.is((Matcher)Matchers.instanceOf(NoListenerRequestHandler.class)));
    }

    @Test
    public void httpListenerRegistryReturnsBadRequestHandlerOnMalformedUrl() {
        HashMap<String, RequestHandler> requestHandlerPerPath = new HashMap<String, RequestHandler>();
        HttpListenerRegistry listenerRegistry = new HttpListenerRegistry();
        RequestHandler getHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
        requestHandlerPerPath.put(FIRST_LEVEL_CATCH_ALL, getHandler);
        listenerRegistry.addRequestHandler(this.testServer, (RequestHandler)requestHandlerPerPath.get(FIRST_LEVEL_CATCH_ALL), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.GET}), FIRST_LEVEL_CATCH_ALL));
        HttpRequest mockRequest = this.createMockRequestWithPath(MALFORMED);
        Mockito.when((Object)mockRequest.getMethod()).thenReturn((Object)HttpConstants.Method.GET.name());
        Assert.assertThat((Object)listenerRegistry.getRequestHandler(this.testServer.getServerAddress(), mockRequest), (Matcher)Matchers.instanceOf(BadRequestHandler.class));
    }

    @Test
    public void replacePathCatchAllForCatchAll() {
        this.replace("/a/b/*", "/a/*", "/a/b/c", "/a/c");
    }

    @Test
    public void replacePathCatchAllForUriParam() {
        this.replace("/a/b/*", "/a/{b}", "/a/b/c", "/a/c");
    }

    @Test
    public void replacePathForCatchAll() {
        this.replace("/a/b/c", "/a/*", "/a/b/c", "/a/c");
    }

    @Test
    public void replacePathForUriParam() {
        this.replace("/a/b/c", "/a/{b}", "/a/b/c", "/a/c");
    }

    @Test
    public void replacePathUriParamForCatchAll() {
        this.replace("/a/{b}/c", "/a/*", "/a/b/c", "/a/c");
    }

    @Test
    public void replacePathUriParamForUriParam() {
        this.replace("/a/{b}/c", "/a/{b}", "/a/b/c", "/a/c");
    }

    @Test
    public void removingCatchAllDoesNotAffectParentPath() {
        this.removeChildAndCheckParent("/a", FIRST_LEVEL_CATCH_ALL, "/a/b/c");
    }

    @Test
    public void removingSubPathDoesNotAffectParentPath() {
        this.removeChildAndCheckParent("/a", "/b", "/a/b");
    }

    @Test
    public void removingUriParamDoesNotAffectParentPath() {
        this.removeChildAndCheckParent("/a", "/{b}", "/a/c");
    }

    @Test
    @Ignore(value="MULE-15247: Analyse HTTP listener path behavior for catch all")
    public void removingCatchAllDoesNotAffectParentCatchAll() {
        this.removeChildAndCheckParent(FIRST_LEVEL_CATCH_ALL, FIRST_LEVEL_CATCH_ALL, "/a/b/c");
    }

    @Test
    public void removingSubPathDoesNotAffectParentCatchAll() {
        this.removeChildAndCheckParent(FIRST_LEVEL_CATCH_ALL, "/b", "/a/b");
    }

    @Test
    public void removingUriParamDoesNotAffectParentCatchAll() {
        this.removeChildAndCheckParent(FIRST_LEVEL_CATCH_ALL, "/{param}", "/a/c");
    }

    @Test
    public void removingCatchAllDoesNotAffectParentUriParam() {
        this.removeChildAndCheckParent("/{param}", FIRST_LEVEL_CATCH_ALL, "/a/b/c");
    }

    @Test
    public void removingSubPathDoesNotAffectParentUriParam() {
        this.removeChildAndCheckParent("/{param}", "/b", "/a/b");
    }

    @Test
    public void removingUriParamDoesNotAffectParentUriParam() {
        this.removeChildAndCheckParent("/{param}", "/{param}", "/a/c");
    }

    @Test
    public void removingPathParentPathDoesNotAffectCatchAll() {
        this.removeParentAndCheckChild("/a", FIRST_LEVEL_CATCH_ALL, "/a/b/c");
    }

    @Test
    @Ignore(value="MULE-15247: Analyse HTTP listener path behavior for catch all")
    public void removingParentCatchAllDoesNotAffectCatchAll() {
        this.removeParentAndCheckChild(FIRST_LEVEL_CATCH_ALL, FIRST_LEVEL_CATCH_ALL, "/a/b/c");
    }

    @Test
    @Ignore(value="MULE-15247: Analyse HTTP listener path behavior for catch all")
    public void removingParentUriParamDoesNotAffectCatchAll() {
        this.removeParentAndCheckChild("/{param}", FIRST_LEVEL_CATCH_ALL, "/a/b/c");
    }

    @Test
    public void removingPathParentPathDoesNotAffectSubPath() {
        this.removeParentAndCheckChild("/a", "/b", "/a/b");
    }

    @Test
    public void removingParentCatchAllDoesNotAffectSubPath() {
        this.removeParentAndCheckChild(FIRST_LEVEL_CATCH_ALL, "/b", "/a/b");
    }

    @Test
    public void removingParentUriParamDoesNotAffectSubPath() {
        this.removeParentAndCheckChild("/{param}", "/b", "/a/b");
    }

    @Test
    public void removingPathParentPathDoesNotAffectUriParam() {
        this.removeParentAndCheckChild("/a", "/{param}", "/a/c");
    }

    @Test
    public void removingParentCatchAllDoesNotAffectUriParam() {
        this.removeParentAndCheckChild(FIRST_LEVEL_CATCH_ALL, "/{param}", "/a/c");
    }

    @Test
    public void removingParentUriParamDoesNotAffectUriParam() {
        this.removeParentAndCheckChild("/{param}", "/{param}", "/a/c");
    }

    @Test
    public void removingCatchAllHandlerDoesNotAffectOther() {
        this.removePostAndCheckGet(FIRST_LEVEL_CATCH_ALL);
    }

    @Test
    public void removingPathHandlerDoesNotAffectOther() {
        this.removePostAndCheckGet("/a");
    }

    @Test
    public void removingUriParamHandlerDoesNotAffectOther() {
        this.removePostAndCheckGet("/{a}");
    }

    private void replace(String oldPath, String newPath, String oldRequestPath, String newRequestPath) {
        this.httpListenerRegistry = new HttpListenerRegistry();
        RequestHandler oldPathHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
        RequestHandlerManager oldManager = this.httpListenerRegistry.addRequestHandler(this.testServer, oldPathHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), oldPath));
        this.routePath(oldRequestPath, HttpConstants.Method.GET, oldPathHandler);
        this.routePath(newRequestPath, HttpConstants.Method.GET, (RequestHandler)NoListenerRequestHandler.getInstance());
        oldManager.dispose();
        this.routePath(oldRequestPath, HttpConstants.Method.GET, (RequestHandler)NoListenerRequestHandler.getInstance());
        this.routePath(newRequestPath, HttpConstants.Method.GET, (RequestHandler)NoListenerRequestHandler.getInstance());
        RequestHandler newPathHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
        this.httpListenerRegistry.addRequestHandler(this.testServer, newPathHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), newPath));
        this.routePath(oldRequestPath, HttpConstants.Method.GET, (RequestHandler)(newPath.endsWith(WILDCARD_CHARACTER) ? newPathHandler : NoListenerRequestHandler.getInstance()));
        this.routePath(newRequestPath, HttpConstants.Method.GET, newPathHandler);
    }

    private void removeChildAndCheckParent(String parent, String child, String childRequestPath) {
        this.httpListenerRegistry = new HttpListenerRegistry();
        RequestHandler parentHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
        RequestHandler childHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
        this.httpListenerRegistry.addRequestHandler(this.testServer, parentHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), parent));
        RequestHandlerManager childManager = this.httpListenerRegistry.addRequestHandler(this.testServer, childHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), parent + child));
        this.routePath("/a", HttpConstants.Method.GET, parentHandler);
        this.routePath(childRequestPath, HttpConstants.Method.GET, childHandler);
        childManager.dispose();
        this.routePath("/a", HttpConstants.Method.GET, parentHandler);
        this.routePath(childRequestPath, HttpConstants.Method.GET, (RequestHandler)(parent.endsWith(WILDCARD_CHARACTER) ? parentHandler : NoListenerRequestHandler.getInstance()));
        RequestHandler newChildHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
        this.httpListenerRegistry.addRequestHandler(this.testServer, newChildHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), parent + child));
        this.routePath("/a", HttpConstants.Method.GET, parentHandler);
        this.routePath(childRequestPath, HttpConstants.Method.GET, newChildHandler);
    }

    private void removeParentAndCheckChild(String path, String child, String childRequestPath) {
        this.httpListenerRegistry = new HttpListenerRegistry();
        RequestHandler parentHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
        RequestHandler childHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
        RequestHandlerManager parentManager = this.httpListenerRegistry.addRequestHandler(this.testServer, parentHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), path));
        this.httpListenerRegistry.addRequestHandler(this.testServer, childHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), path + child));
        this.routePath("/a", HttpConstants.Method.GET, parentHandler);
        this.routePath(childRequestPath, HttpConstants.Method.GET, childHandler);
        parentManager.dispose();
        this.routePath("/a", HttpConstants.Method.GET, (RequestHandler)(child.endsWith(WILDCARD_CHARACTER) ? childHandler : NoListenerRequestHandler.getInstance()));
        this.routePath(childRequestPath, HttpConstants.Method.GET, childHandler);
        RequestHandler newParentHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
        this.httpListenerRegistry.addRequestHandler(this.testServer, newParentHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), path));
        this.routePath("/a", HttpConstants.Method.GET, newParentHandler);
        this.routePath(childRequestPath, HttpConstants.Method.GET, childHandler);
    }

    private void removePostAndCheckGet(String path) {
        this.httpListenerRegistry = new HttpListenerRegistry();
        RequestHandler getHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
        RequestHandler postHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
        this.httpListenerRegistry.addRequestHandler(this.testServer, getHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.GET}), path));
        RequestHandlerManager manager = this.httpListenerRegistry.addRequestHandler(this.testServer, postHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.POST}), path));
        this.routePath("/a", HttpConstants.Method.GET, getHandler);
        this.routePath("/a", HttpConstants.Method.POST, postHandler);
        manager.dispose();
        this.routePath("/a", HttpConstants.Method.GET, getHandler);
        this.routePath("/a", HttpConstants.Method.POST, (RequestHandler)NoMethodRequestHandler.getInstance());
        RequestHandler newPostHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
        this.httpListenerRegistry.addRequestHandler(this.testServer, newPostHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.POST}), path));
        this.routePath("/a", HttpConstants.Method.GET, getHandler);
        this.routePath("/a", HttpConstants.Method.POST, newPostHandler);
    }

    private void routePath(String requestPath, String listenerPath) {
        Assert.assertThat((Object)this.httpListenerRegistry.getRequestHandler((ServerAddress)new DefaultServerAddress(TEST_IP, 10000), this.createMockRequestWithPath(requestPath)), (Matcher)Is.is((Object)this.requestHandlerPerPath.get(listenerPath)));
    }

    private void routePath(String requestPath, HttpConstants.Method requestMethod, RequestHandler expectedRequestHandler) {
        HttpRequest mockRequest = this.createMockRequestWithPath(requestPath);
        Mockito.when((Object)mockRequest.getMethod()).thenReturn((Object)requestMethod.name());
        Assert.assertThat((Object)this.httpListenerRegistry.getRequestHandler((ServerAddress)new DefaultServerAddress(TEST_IP, 10000), mockRequest), (Matcher)Is.is((Object)expectedRequestHandler));
    }

    private HttpRequest createMockRequestWithPath(String path) {
        HttpRequest mockRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)mockRequest.getPath()).thenReturn((Object)path);
        return mockRequest;
    }

    private HttpListenerRegistry createHttpListenerRegistryWithRegisteredHandlers() {
        HttpListenerRegistry httpListenerRegistry = new HttpListenerRegistry();
        this.requestHandlerPerPath.put("/", (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(FIRST_LEVEL_CATCH_ALL, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(FIRST_LEVEL_PATH_LOWER_CASE, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(FIRST_LEVEL_PATH_UPPER_CASE, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(FIRST_LEVEL_PATH_UPPER_CASE_CATCH_ALL, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(SECOND_LEVEL_PATH, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(SECOND_LEVEL_URI_PARAM, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(FOURTH_LEVEL_CATCH_ALL, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(URI_PARAM_IN_THE_MIDDLE, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(CATCH_ALL_IN_THE_MIDDLE_NO_COLLISION, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(SEVERAL_CATCH_ALL, (RequestHandler)Mockito.mock(RequestHandler.class));
        for (String path : this.requestHandlerPerPath.keySet()) {
            httpListenerRegistry.addRequestHandler(this.testServer, this.requestHandlerPerPath.get(path), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), path));
        }
        httpListenerRegistry.addRequestHandler(this.testServer, this.methodPathUriParamGetRequestHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.GET}), METHOD_PATH_URI_PARAM));
        httpListenerRegistry.addRequestHandler(this.testServer, this.methodPathUriParamPostRequestHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.POST}), METHOD_PATH_URI_PARAM));
        httpListenerRegistry.addRequestHandler(this.testServer, this.methodPathCatchAllGetRequestHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.GET}), METHOD_PATH_CATCH_ALL));
        httpListenerRegistry.addRequestHandler(this.testServer, this.methodPathCatchAllPostRequestHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.POST}), METHOD_PATH_CATCH_ALL));
        httpListenerRegistry.addRequestHandler(this.testServer, this.methodPathWildcardGetRequestHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.GET}), METHOD_PATH_WILDCARD));
        httpListenerRegistry.addRequestHandler(this.testServer, this.methodPathWildcardPostRequestHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)new DefaultMethodRequestMatcher(new HttpConstants.Method[]{HttpConstants.Method.POST}), METHOD_PATH_WILDCARD));
        return httpListenerRegistry;
    }

    private void validateNoCollision(String ... paths) {
        HttpListenerRegistry httpListenerRegistry = new HttpListenerRegistry();
        for (String path : paths) {
            httpListenerRegistry.addRequestHandler(this.testServer, this.mockRequestHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), path));
        }
    }

    private void validateCollision(String firstPath, String secondPath) {
        HttpListenerRegistry httpListenerRegistry = new HttpListenerRegistry();
        httpListenerRegistry.addRequestHandler(this.testServer, this.mockRequestHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), firstPath));
        this.expectedException.expect(MuleRuntimeException.class);
        httpListenerRegistry.addRequestHandler(this.testServer, this.mockRequestHandler, (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), secondPath));
    }

    @Test
    @Description(value="Verify that a path using wildcards and a path involving a longer subpath are correctly resolved.")
    public void validateWildcardPathWithLongPath() {
        this.httpListenerRegistry = new HttpListenerRegistry();
        this.requestHandlerPerPath.put(SECOND_LEVEL_CATCH_ALL, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.httpListenerRegistry.addRequestHandler(this.testServer, this.requestHandlerPerPath.get(SECOND_LEVEL_CATCH_ALL), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), SECOND_LEVEL_CATCH_ALL));
        this.requestHandlerPerPath.put("/first-level-path/second-level/another-path", (RequestHandler)Mockito.mock(RequestHandler.class));
        this.httpListenerRegistry.addRequestHandler(this.testServer, this.requestHandlerPerPath.get("/first-level-path/second-level/another-path"), (PathAndMethodRequestMatcher)new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), "/first-level-path/second-level/another-path"));
        this.routePath("/first-level-path/second-level/some-path", SECOND_LEVEL_CATCH_ALL);
        this.routePath("/first-level-path/second-level/some-path/some-other-path", SECOND_LEVEL_CATCH_ALL);
        this.routePath("/first-level-path/second-level/another-path", "/first-level-path/second-level/another-path");
    }
}

